﻿var CommandErrorType = {

    javascriptexecption: "javascript" ,
    network: "network",
    request: "request" ,
    success: "success" 
}






function SOAPWebServiceCall(commmand, _asmxUrl, _method, onError, onDebug)
{
    var _methodName = _method;
    var _command = commmand;
    var _methodParams = null;
    var _callback = null;
    var _objXmlHttp = CreateXmlHttpObject();
    var _serviceUrl = _asmxUrl;
    var _errorMessage = null;
    var _onRequestError = onError;
    var _onRequestDebug = onDebug;
    var _completed = false;
    var _aborted = false;
    var m_WebService = this;

    this.getAjaxObj = function () {return _objXmlHttp;};
    this.getErrorMessage = function () {return _errorMessage;};
    this.setParams = function (_arr) 
    {
        if (null === _arr || 0 === _arr.length) {
            _methodParams = null;
        } 
        else {
            // array of string (name1,value1,name2,value2...
            if (0 === (_arr.length % 2)) {
                _methodParams = _arr;
            }
        }
    };


    this.debug = function (message) {

        if (typeof _onRequestDebug != "function")
            return;

        _onRequestDebug(message);
        return;
    };


    this.error = function (message) {
        if (typeof _onRequestError != "function")
            return;

        _onRequestError(message);
        return;
    };

    this.getURL = function () {
        return _serviceUrl;
    };

    this.getMethod = function () {
        return _methodName;
    };

    this.getThisPtr = function () {
        return this;
    };


    this.abort = function () {
        if (_objXmlHttp != null) {
            var x = this._serviceUrl;
            _aborted = true;
            _objXmlHttp.abort();
            _completed = true;
        }
    };

    function CreateXmlHttpObject() 
    {
        var _oXmlHttp = null;
        if (navigator.userAgent.indexOf("Opera") >= 0) {
            m_WebService.error("Opera is not supported.");
            return null;
        }
        if (navigator.userAgent.indexOf("MSIE") >= 0) {
            var strName = "Msxml2.XMLHTTP";
            if (navigator.appVersion.indexOf("MSIE 5.5") >= 0) {
                strName = "Microsoft.XMLHTTP";
            }
            try 
            {
                _oXmlHttp = new ActiveXObject(strName);
                return _oXmlHttp;
            } 
            catch (e) 
            {
                _errorMessage = "Not able to instanciate the AJAX object. Error. Scripting for ActiveX might be disabled: " + e.message;
                m_WebService.error(_errorMessage, true);
                return null;
            }
        }
        if (navigator.userAgent.indexOf("Mozilla") >= 0) {
            _oXmlHttp = new XMLHttpRequest();
            return _oXmlHttp;
        }
        return (null);
    }

    this.CreateSoapEnveloppe = function(_method, _params) 
    {
        var _s = "";
        _s += "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        _s += "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">";
        _s += "<soap:Body>";
        _s += "<" + _method + " xmlns=\"http://www.voxco.com/\">";
        if (_params != null) 
        {
            var i;
            for (i = 0; i < _params.length; i += 2) 
            {
                _s += "<" + _params[i] + ">" + _params[i + 1] + "</" + _params[i] + ">";
            }
        }
        _s += "</" + _method + ">";

        _s += "</soap:Body></soap:Envelope>";
        return (_s);
    }

    this.ParseResponse = function(_s)
    {
        var _ss = "";
        var _srch = _methodName + 'Result';
        var _p = _s.indexOf('<' + _srch);
        if (_p != -1) {
            _ss = _s.substr(_p);
            _p = _ss.indexOf('</' + _srch);
            if (_p != -1) {
                _s = _ss.substr(0, _p + 3 + _srch.length);
                // s= <xResult>0</xResult>
                _s = _s.substr(_s.indexOf('>') + 1);
                _s = _s.substr(0, _s.lastIndexOf('<'));
            } 
            else {
                _p = _ss.indexOf('</' + _methodName + "Response>");
                if (_p != -1) {
                    _ss = _ss.substr(0, _p);
                    _p = _ss.indexOf('>');
                    if (_p === _ss.length - 1) {
                        _s = ""; // <xResult/> : no data
                    }
                }
            }
        } 
        else {
            _s = ""; //no result or null
        }
        return (_s);
    }

    this.execute = function () {
        try {
            if (_objXmlHttp != null) {
                _objXmlHttp.abort();
                if (arguments.length > 0) { _callback = arguments[0]; }
                if (null === _methodName || 0 === _methodName.length) {
                    _errorMessage = 'Invalid method';
                }
                else if (null === _serviceUrl || 0 === _serviceUrl.length) {
                    _errorMessage = 'Invalid URL';
                }
                else {
                    var _soap = m_WebService.CreateSoapEnveloppe(_methodName, _methodParams);

                    _objXmlHttp.onreadystatechange = this.processStateChanged;
                    _objXmlHttp.open("POST", _serviceUrl, true);
                    _objXmlHttp.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
                    _objXmlHttp.setRequestHeader("SOAPAction", "\"http://www.voxco.com/" + _methodName + "\"");
                    _objXmlHttp.send(_soap);
                }
            }
        }
        catch (e) {
            _errorMessage = "Caught an exception when sending command "+ _command + ". Reason: " + e.message;
        }

        if (_errorMessage != null) {

            if (_callback != null)
                _callback(false, this,_errorMessage);
        }
    };

    this.processStateChanged = function () {

        var _errorMessage = null;
        var _httpstatus = "" ;

        try {

            if (null === _objXmlHttp) {
                m_WebService.error('SOAPWebServiceCall.processStateChanged>  null objXmlHttp');
                _completed = true;
                return;
            }

            if (4 === _objXmlHttp.readyState || _objXmlHttp.readyState === "complete") {

                if (_aborted) {
                    m_WebService.error("SOAPWebServiceCall.processStateChanged> http request was aborted. The command aborted is: " + _command);
                    _completed = true;
                    return;
                }
                
                if (200 === _objXmlHttp.status) {

                    if (_callback != null) {
                        _callback(true, this, m_WebService.ParseResponse(_objXmlHttp.responseText), _objXmlHttp.status);
                    }

					m_WebService.abort() ;
                    return;
                }

                _httpstatus =_objXmlHttp.status ;

                _errorMessage = "Fail to send http request for  " + _command + " command -- http error: " + _objXmlHttp.status + ".";
				m_WebService.abort() ;
	        }
        }
        catch (e) {

            _httpstatus = 911;
            _errorMessage = "When sending http request for " + _command + " command we caught a javascript exception:  " + e.message + " -- http error: " + _httpstatus;
        	 m_WebService.abort() ;
	    }

        if (_errorMessage != null) {
            if (_callback != null) {
                _callback(false, this, _errorMessage, _httpstatus);
            }
        }
    }
}


//
//  Chronotimer permet de calculer un temps en milli seconde entre le demarrage et l'arret . Tant et 
//  aussi longtemps que la methode reset n'est pas appele nous cumulons le temps a chaque demarrage et arret
//
//  onDebug -> callback de log
//  method  -> Nom de l'object qui utilise le chronometre
//  verb    -> Pause , wait , delay
//
//  Ce chronometre est surtout utilise pour les statistique de waiting time , pause time et delay time . Ces
//  variable de temps sont envoye a intweb pour fin de statistique 
//

function Chronotimer(method, verb, onDebug) {
    var m_Start = null;
    var m_Stop = null;
    var m_Method = method;
    var m_Verb = verb;
    var _onDebug = onDebug;
    var m_iTotalMSChronoTime = 0;
    var m_Chrono = this;


    this.debug = function (message) {
        if (typeof _onDebug != "function")
            return;

        if (typeof m_Method != "string")
            m_Method = "chronometer";

        _onDebug(m_Method + ".timer> " + message);

        return;
    }

    //
    //.. Demarrage du timer . Si deja demarré nous ne faisons rien
    //  
    this.Start = function () {
        if (typeof m_Verb != "string")
            m_Verb = "time";

        if (m_Start == null && m_Stop == null) {
            m_Start = new Date().getTime();
            m_Stop = m_Start;

            m_Chrono.debug("start time: " + "The total time for " + m_Verb + " is: " + m_iTotalMSChronoTime + " ms");
        }
    }

    //
    //
    //  Retourne le temps calculé a partir du dernier démarrage du timer.
    //
    this.Calculate = function () {

        if (m_Start == null) {
            m_Chrono.debug("Not able to calculate elapse time " + m_Verb + " . Timer is not started.");
            return 0;
        }

        m_Stop = new Date().getTime();

        var elapsetime = m_Stop - m_Start;
        if (elapsetime < 0)
            elapsetime = 0;

        //
        //  On cumule le temps en milli seconde jusqu'au reset.
        //
        m_iTotalMSChronoTime += elapsetime;
        m_Chrono.debug("stop time: " + "The total time for " + m_Verb + " is: " + m_iTotalMSChronoTime + " ms secs" + " -- elapse time: " + elapsetime + " ms");

        m_Stop = null;
        m_Start = null;
        return Math.round(elapsetime / 1000);
    }

    //
    //  Arret du compteur. A chaque arret nous cumulons le temps.
    //


    this.Stop = function () {
        return m_Chrono.Calculate();
    }

    this.GetMilliSecond = function (bStop) {

        if (typeof bStop == "boolean" && bStop == true)
            m_Chrono.Calculate();

        return m_iTotalMSChronoTime;
    }

    this.Get = function () {
        return Math.round(m_iTotalMSChronoTime / 1000);
    }

    //
    //  Reset est appele lorsque nous voulons la valeur final 
    //
    this.Reset = function () {

        m_Chrono.debug("reset timer: total time for " + m_Verb + " is:  " + m_iTotalMSChronoTime + " ms");
        m_Chrono.Stop();

        var Chrono = m_Chrono.Get();
        m_iTotalMSChronoTime = 0;
        m_Stop = null;
        m_Start = null;

        return Chrono;
    }


    this.Restart = function () {
        this.Reset();
        this.Start();
        return;
    },

    this.isChronometerStarted = function () {
        var bStarted = true;
        if (m_Start == null)
            bStarted = false;

        return bStarted;
    }
}



//
//  Cet objet java script permet de conserver les statistiques 
//  envoye a IntWeb pour fin de verification. Ils sont ecrites dans 
//  les logs de voxco.agent .
//
//  A chaque appel nous enregistrons les statistiques suivantes:
//      - Pause time :  le temps de pause de l'agent ( bouton pause )
//      - Delay time :  le temps accorde entre la fin de l'entrevue et le debut du wait 
//        Ce temps a configurable avec commande center parmi les parametres du projet
//      - Watting time :  le temps d'attente avant de recevoir un appel
//      - Call length : la duree de l'appel
//
//  Il donne egalement les statistiques suivantes:
//
//      - la duree de la session
//      - le nombre d'appels
//      - le total des statistiques pause time , waiting time, delay time
//      - le total de temps de connexion avec un repondant.
//
//  Ces statisques sont inscrites a la fermeture de la session
//
//      m_onLogCallBack     : call back pour les logs
//      m_onLogSyncCallBack : call back poir les logs mais synchrone
//       
//
var CallStats = {

    //
    //  m_Chronometer   : calcule la duree d'appel
    //  m_SessionTimer  : calcule la duree de la session de l'agent
    //
    m_Chronometer :null ,
    m_SessionTimer: null ,
      
    m_iTotalWaitTime        : 0 ,
    m_iTotalPauseTime       : 0 ,
    m_iTotalDelayTime       : 0 ,
    m_iLastWaitTime         : 0 ,
    m_iLastPauseTime        : 0 ,
    m_iLastDelayTime: 0,
    m_iLoginTime: 0 ,
    m_iTotalCallDuration: 0,
    m_iLastCallDuration: 0,
    m_iNbCalls: 0,
    m_iNetworkError: 0 ,
    m_bClose: false ,
    m_onLogCallBack: null,
  
    init: function (onLog) {
        this.m_Chronometer  =  new Chronotimer("CallStats", "calllength", this.trace),
        this.m_SessionTimer = new Chronotimer("CallStats", "session", this.trace),
        this.m_onLogCallBack = onLog;
    },

    addWaitTime: function (Timer, bCallStart) {

        if (typeof bCallStart == "boolean" && bCallStart == true)
            this.callStart();

        if (typeof Timer != "object")
            return;

        this.m_iLastWaitTime = Timer.GetMilliSecond();
        this.m_iTotalWaitTime += this.m_iLastWaitTime;
        return
    },

    Reset: function()
    {
        this.m_iTotalWaitTime  = 0 ;
        this.m_iTotalPauseTime = 0 ;
        this.m_iTotalDelayTime = 0 ;
        this.m_iLastWaitTime   = 0 ;
        this.m_iLastPauseTime  = 0 ;
        this.m_iLastDelayTime  = 0 ;
        this.m_iLoginTime      = 0 ;
        this.m_iTotalCallDuration= 0 ;
        this.m_iLastCallDuration= 0 ;
        this.m_iNbCalls = 0;
    },

    addPauseTime: function (Timer,bCalculate ) {

        try {
            if (typeof Timer != "object")
                return;
          
            this.m_iLastPauseTime = Timer.GetMilliSecond(bCalculate);
            this.m_iTotalPauseTime += this.m_iLastPauseTime;

            return Timer.Get();
        }
        catch (e) {

        }
    },

    addDelayTime: function ( Timer , bCalculate ) {

        try {
            if (typeof Timer != "object")
                return;

            this.m_iLastDelayTime = Timer.GetMilliSecond(bCalculate);
            this.m_iTotalDelayTime += this.m_iLastDelayTime;
        }
        catch (e) {

        }

        return;
    },

    callStart: function () {
        this.m_iNbCalls++;
        this.m_Chronometer.Start();
    },

    callEnd: function () {

        this.m_Chronometer.Stop();

        var msElapsetime = this.m_Chronometer.GetMilliSecond();
        
        this.m_iTotalCallDuration += msElapsetime;
        this.m_iLastCallDuration = msElapsetime;

        this.info("stats.call>" + " call: " + this.m_iNbCalls + " | call lengh: " + this.m_iLastCallDuration + " |waiting time: " + this.m_iLastWaitTime + " |pause time: " + this.m_iLastPauseTime + " |delay time: " + this.m_iLastDelayTime);
        this.m_Chronometer.Reset();
    },
    
    isCallReceived: function () {

        var bCallReceived = true;
        if (this.m_iNbCalls == 0)
            bCallReceived = false;

        return bCallReceived;
    },


    //
    //  Demarrage du timer de session
    //
    open: function(){
        this.m_SessionTimer.Start();
    },
    
    //
    //  Arret du timer de session
    //
    close: function () {

        if (this.m_bClose == true)
            return;

        this.m_bClose = true;
        var session = this.m_SessionTimer.GetMilliSecond(true);
        var elapseTimeinSecond = this.m_SessionTimer.Reset();
        var totaltime = this.m_iTotalCallDuration + this.m_iTotalDelayTime + this.m_iTotalWaitTime + this.m_iTotalPauseTime;

        this.info("stats.close> total calls: " + this.m_iNbCalls + " |total call lengh: " + this.m_iTotalCallDuration + " |total waiting time: " + this.m_iTotalWaitTime + " |total pause time: " + this.m_iTotalPauseTime + " |total delay time: " + this.m_iTotalDelayTime + " |total time: " + totaltime + " |session time: " + session + "|network error:" + this.m_iNetworkError, true);
    },

    addNetworkError: function () {
        this.m_iNetworkError++;
    },

    info: function ( message, bSync ) {

        if (typeof bSync != "boolean" ) {
            bSync = false;
        }
        
        if (typeof this.m_onLogCallBack == "function") {
            this.m_onLogCallBack(LogLevel.info, message, bSync);
        }

        return;
    },

    trace: function (message, bSync) {
        if (typeof CallStats.m_onLogCallBack == "function") {
            CallStats.m_onLogCallBack(LogLevel.trace, message, bSync);
        }

    }

}





    //
    //  Cet objet permet de parser les reponses en provenance de voxco.agent.webservice. En plus de decortiquer la reponse
    //  elle les garde de maniere structure pour consultation si besoin est:
    //
    //  cmdname         : contient le nom de la commande ( wait , pause , int-complete ... )
    //  response        : contient la reponse  a la requete
    //  errorcallback   : callback pour la notifications des erreurs. Normale le callback appartient a la commande comme
    //  onParserCallback: callback de parsing utilise en fonction du context ( nouvelle appel , message asynchrone , commande )
    //                    Dependament de la situation les reponses ont un format different
    //

    function ResponseParser(cmdname, response, onError,  onDebug, onParserCallback) {

        var m_response = response;
        var m_CmdName = cmdname;
        var m_onError = onError;
        var m_onDebug = onDebug;
        var m_onParseCallBack = onParserCallback;
        var m_responseProperty = { m_szCmd:"" , m_szStatus:"" , m_szResponseLine:"" ,   m_szArgument:[] , parameters:{}};
        var m_ParserClass = this;

        //
        //  La syntaxe du message est:
        //
        //  command//result;name:value;name:value ...
        //
        //  malheureusement le format des reponses n'est pas constant dependamment si nous executons un mask ou un bouton
        //  de controle.
        //
        //  Bouton de controle:
        //
        //      result;name:value;name:value ...
        //  
        //  Mask:
        //       command//result;name:value;name:value ...
        //
        this.parse = function( fieldSeparator , argument ){

            if (typeof fieldSeparator == "undefined")
                fieldSeparator = ";";

            m_responseProperty.m_szResponseLine = m_response;
            var _CmdParts = m_responseProperty.m_szResponseLine.split(fieldSeparator);
            var _CmdVals = _CmdParts[0].split('//');

            if (typeof _CmdVals[0] == "string")
                m_responseProperty.m_szCmd = _CmdVals[0];

            if (typeof _CmdVals[1] == "string")
                m_responseProperty.m_szStatus = _CmdVals[1];

            for (index in _CmdParts) {
                if (index > 0)
                    m_responseProperty.m_szArgument[index - 1] = _CmdParts[index];
            }

            if (m_responseProperty.m_szStatus.length == 0) {
                //
                //  Aucun status ,dans le doute nous forcons le status a OK. Pour le message asynchrone aucun status donc 
                //  c'est normal
                //
                m_responseProperty.m_szStatus = "OK";
                if (m_CmdName != "async" && m_CmdName != "getMessages")
                    m_ParserClass.error("ResponseParser.parse> no status found in the request response of " + m_CmdName);
            }

            //
            //  Nous avons une erreur sur la requete
            //
            if (m_responseProperty.m_szStatus == "ERR") {
                m_ParserClass.setParameter(m_responseProperty.m_szStatus, m_responseProperty.m_szArgument[0]);
                return;
            }
       
            m_ParserClass.debug("ResponseParser.parse> parsing arguments '" + m_responseProperty.m_szResponseLine + "'");

            //
            //  Collection des parametres. Si le format est different name=value ou nous devons effectuer des 
            //  operations intermediaire , m_onParseCallBack est utilise. C'est le cas pour les appels entrant
            //

            var index = 0;
            for (index = 0  ; index < m_responseProperty.m_szArgument.length ; index++) {

                var parameter = m_responseProperty.m_szArgument[index];     
                if (typeof m_onParseCallBack == "function") {

                    var bStop = m_onParseCallBack(parameter, index);
                    if (bStop == true)
                        break;

                    continue;
                }

                var pair = parameter.split(":");
                if (pair.length < 2)
                    m_ParserClass.setParameter(pair[0], "");
                else
                    m_ParserClass.setParameter(pair[0], pair[1]);
            }

            return;
        }


        //
        //  Retourne le nom de la commande qui a recu une reponse de voxco.agent.webservice
        //
        this.getCmd = function () {

            if (typeof m_responseProperty.m_szCmd != "string" || m_responseProperty.m_szCmd.length == 0 )
                return "unknown";

            return m_responseProperty.m_szCmd;
        }


        this.getMissCallData = function () {

            if (m_responseProperty.m_szArgument.length < 2)
                return false;

            var call;
            for (index = 2; index < m_responseProperty.m_szArgument.length; index++) {
                call += m_responseProperty.m_szArgument[index];
                call += ";";
            }

            return call;
        }

        this.SetCallInfoOnMissCall = function( callback )
        {
            if (CallClass.isInCall() == true)
                return false;

            if (m_responseProperty.m_szArgument.length < 2)
                return false;

            for (index = 2; index < m_responseProperty.m_szArgument.length; index++) {

                var parameter = m_responseProperty.m_szArgument[index];
                var pair = parameter.split(":");
                if (pair.length < 2) {
                    m_ParserClass.setParameter("recordid", pair[0]);
                    continue;
                }

                m_ParserClass.setParameter(pair[0], pair[1]);
            }

            return true;
        }
        //
        //  Mise a jour du parametre 
        //
        this.setParameter = function( name , value ){

            try{
                m_ParserClass.debug("ResponseParser.setParameter>" + " (" + m_responseProperty.m_szCmd + ")" + " Setting parameter " + name + " to " + value);
                m_responseProperty.parameters[ name ]  = value;
            }
            catch( e ){
                m_ParserClass.debug("ResponseParser.setParameter>" + " (" + m_responseProperty.m_szCmd + ")" + " Not able to set parameter " + name + " for command " + this.m_CmdName);
                m_responseProperty.parameters[ name ]  = value;
            }
        }

        //
        //  Retourne le status de la reponse 
        //
        this.getStatus = function(){
            return m_responseProperty.m_szStatus ;
        }


        this.getBool =  function (szName) {

            var bValue = false;
            var szValue = this.getParameter(szName, "");
            if (szValue.length == 0)
                return bValue;

            bValue = szValue.toUpperCase() == "TRUE" ? true : false;
            return bValue;
        }



        //
        //  verification du status. Exemple isStatus("CANCEL")
        //
        //  false -> pas le bon status
        //  true  -> le bon status
        //

        this.isStatus = function (szStatus) {
            if (typeof szStatus != "string")
                return false;

            if (szStatus == m_responseProperty.m_szStatus)
                return true;

            return false;
        }


        this.clearArgument = function () {
            m_responseProperty.m_szArgument = "";
        }


        //
        //  retourne le parametre contenu dans la reponse . Si non existant , nous retournons la valeur de default
        //
        //  Exemple:  
        //
        //      var myValue = getParameter( "recordid" , "0" ) ;
        //
        //
        this.getParameter = function( name , defaultvalue )
        {
            try{

                if( typeof defaultvalue == "undefined" )
                    defaultvalue = "" ;

                var value = m_responseProperty.parameters[ name ] ;
                if( typeof value == "undefined" ){
                    m_ParserClass.debug("getParameter> parameter name " + name + " is not found. Returning default value: " + defaultvalue);
                    value = defaultvalue ;
                }

                return value ;
                
            }
            catch( e ){
                m_ParserClass.debug("getParameter> not able to get parameter for command " + m_CmdName + ". Reason:", e.message);
            }

            return defaultvalue;
        }


        this.getArgument = function () {
            return m_responseProperty.m_szArgument;
        }

  
        this.isRequestStatusError = function(){

            var bError = true;
            var status = m_responseProperty.m_szStatus.toLowerCase();
            if (status == "ok")
                bError = false;

            return bError;
        }

        //
        //
        //  Selon les situations nous desirons avoir une methode pour effectuer la lecture de parametres.
        //
        //

        this.setOnParse = function ( onParse ) {
            if (typeof onParse != "function")
                return;

            m_onParseCallBack = onParse;
            return;
        }

        //
        //  Permet de lire les requetes de type asynchrone. Le format de la reponse est legerement different des autres
        //  type de messages . Les requetes asynchrones sont par exemple:
        //
        //  1) call-disconnect 
        //  2) remote-agent-disconnect 
        //  3) evt-no-sample-available 
        //  4) etc
        //

        this.onAsyncEvent = function (  parameter ) {

            var pair = parameter.split(":");
            if (pair.length < 2) {
                m_ParserClass.setParameter("recordid", pair[0]);
                return;
            }

            var szName = pair[0];
            var szValue = pair[1];

            m_ParserClass.setParameter(szName, szValue);
            return;
        }

        this.getRawResponse = function()
        {
            return m_responseProperty.m_szResponseLine;
        }

        this.onAsyncBlend = function (parameter, index ) {
            switch (index) {
                case "0":
                    m_ParserClass.setParameter("projectid", parameter);
                    break;
                case "1":
                    m_ParserClass.setParameter("projectname", parameter);
                    break;
                default:
                    m_ParserClass.debug("onAsyncBlend> index field not supported " + index + "-- parameter " + parameter );
                    break;
            }
            return;
        }

        //
        // Nous avons recu un appel. le format de messages est legerement different lorsque nous recevons un appel. En general
        // le format est commmand//status;name:value....
        //
        // Dans le cas d'un nouvelle appel nous avons :
        //
        //  command//status;recordid;name:value;name:value ...params:name=value
        //
        this.onNewCall = function (parameter) {

            var bStopped = false;

            //
            //  La commande wait nous revient avec le status cancel. Les raisons:
            //
            //  1) le projet a ete mis en pause par un utilisateur de command center
            //  2) le projet a ete arrete par un utilisateur de command center
            //  3) L'agent a appuye sur le bouton pause.
            //
            if (m_ParserClass.isStatus("CANCEL") == true) {

                switch (m_responseProperty.m_szArgument[0]) {

                    case 'PAUSE':
                    case 'pause':
                    case 'STOP':
                    case 'stop':
                    
                        //
                        //  Le projet a change d'etat , il est maintenant en pause ou arreter
                        //
                        m_ParserClass.setParameter("reason", m_responseProperty.m_szArgument[1]);
                        break;

                    default:
                  
                        break;
                }
        
                //
                // TODO bug avec voxco.agent.webservice. Sur l'action du bouton pause , le service nous
                // retourne la string XML envoye a voxcobridge... a Corrige 
                //
                m_ParserClass.clearArgument();
                return true;
            }

            //
            //  Nous avons un record id
            //
            var pair = parameter.split(":");
            if (pair.length < 2) {
                m_ParserClass.setParameter("recordid", pair[0]);
                return;
            }

            var szName = pair[0];
            var szValue = pair[1];

            //
            //  Appel en inbound avec les parametres attaches
            //
            if (szName == "PARAMS") {
                //
                //  PARAMS:name=value;
                //
                var _query = szValue.split("=");
                if (_query.length == 2) {

                    if (CallClass.m_InboundParameterList.length != 0)
                        CallClass.m_InboundParameterList += ";";

                    CallClass.m_InboundParameterList += _query[0];
                    CallClass.m_InboundParametersValue += "&" + szValue;
                }

                return;
            }

            m_ParserClass.setParameter(szName, szValue);
            return;
        }

        this.error = function ( message ) {
            if (typeof m_onError != "function")
                return;

            m_onError(message);
        }

        this.debug = function( message )
        {
            if (typeof m_onDebug != "function")
                return;

            m_onDebug(message);
            return ;
        }
    }


    //
    //  Cette classe contient les information sur l'appel entrant . Utiliser par :
    //
    //  1) command dial
    //  2) appel en inbound
    //  3) appel en outbound pour les projets automatiques ( predictif , hybride , non-pred )
    //
    //

    var CallClass = {

        m_Parser: null,
        m_bInCall: false,
        m_bInInterview: false,
        m_szError : "" ,
        m_InboundParameterList: "",
        m_InboundParametersValue: "" ,
        m_onCallDrop : null ,

        Init: function( onCallDrop  )
        {
            if (onCallDrop != null && typeof onCallDrop == "function")
                this.m_onCallDrop = onCallDrop;
        
            return;
        },


        Parse: function (cmd, szFieldSepartor, arguments, onError ) {

            if (typeof onError != "function")
                onError = this.error;

            this.m_bInCall = false;
            this.m_Parser = new ResponseParser(cmd, arguments, onError);
            this.m_Parser.setOnParse(this.m_Parser.onNewCall);
            this.m_Parser.parse(szFieldSepartor);

            //
            //  Nous avons recu un appel . Si le mode est preview ( P ) l'agent n'est pas encore en appel
            //
            //
            var mode      = this.m_Parser.getParameter("MODE", "");
            switch (mode) {
                case 'P':
                    this.setInInterview(true);
                    break;

                case 'O':
                case 'I':
                    this.setInCall(true);
                    this.setInInterview(true);
                    break;

                default:

                    if (this.isNewCall() == true)
                        this.error("CallClass.Parse> We received a new call but we are not able to identify the call mode '" + mode + "'");

                    break;
            }

            return;
        },

        isRespondent: function ( szPhoneNumber) {

            var callingnumber = this.Get("CALLINGNUMBER", "0");
            var callid        = this.Get("CALLID", "");
     
            var result = false;
            if (szPhoneNumber == callingnumber && callid.length != 0 )
                result = true;

            return result;
        },

        setInInterview: function (bInInterview) {

            if (typeof bInInterview == "boolean") {
                this.m_bInInterview = bInInterview;
            }
        },

     
        setInCall: function (bInCall) {

            if (typeof bInCall == "boolean") {
                this.m_bInCall = bInCall;
            }
        },

        clearArgument: function () {

            if (typeof this.m_Parser != "object" || this.m_Parser == null)
                return;

            this.m_Parser.clearArgument() ;
        },

        isRepondentLine: function( line )
        {
            //
            // si la variable est non defini , nous retournons que nous sommes la line du repondant .
            // Comme le protocole entre les differents intervenant ( pronto , voxcobridge , voxco.agent.webservice )
            // n'est pas constant , il est possible que le parametre soit non defini.  99 pourcent du temps
            // la ligne est la ligne du repondant
            //
            if (typeof line == "undefined")
                return true;

            var bPrimaryLine = false ;
            var primaryLine = this.Get('LINE')
            if( primaryLine == line )
                bPrimaryLine = true ;

            return bPrimaryLine ;
        },
        //
        //  Liste de nom des variables utilisee par intweb  var1;var2 -> exemple http://mtl-lab-504/Survey/intweb.dll?questionlist=var1;var2
        //
        getInboundParameterListName: function () {
            return this.m_InboundParameterList;
        },

        //
        //  Liste des variables utilisee par intweb var1=&var2= . exemple:http://mtl-lab-504/Survey/intweb.dll?var1=&var2=
        //
        getInboundParameterListValue: function () {
            return this.m_InboundParametersValue;
        },

        //  
        //  Retourne la status de la reponse a une requete donne
        //

        getStatus: function () {

            if (typeof this.m_Parser != "object" || this.m_Parser == null)
                return "";

            this.m_Parser.getStatus() ;
        },

        getBool: function (szName) {

            if (typeof this.m_Parser != "object" || this.m_Parser == null)
                return "" ;

            return this.m_Parser.getBool(szName);
        },
   
        //
        //  Retourne la variable du parser . Elle contient la liste de tous les parametres recus 
        //
        getParser: function(){
            return this.m_Parser ;
        },

        Set: function (szName, szValue) {

            if (typeof this.m_Parser != "object" || this.m_Parser == null)
                return "";

            this.m_Parser.setParameter(szName, szValue);
            return ;
        },
    
        // Function createNewCallFromMessage and createNewCall replace obsolete createNewCallPublishObject
        createNewCallFromMessage: function () {

            var newcall = { projectid: "", recordid: "" };
            if (typeof this.m_Parser == "object" && this.m_Parser != null) {
                newcall.projectid = this.m_Parser.getParameter("projectid", "");
                newcall.recordid = this.m_Parser.getParameter("recordid", "");
            }

            return newcall;
        },
        
        createNewCall: function (recordid, projectid) {
            var newcall = { projectid: "", recordid: "" };

            if (typeof recordid == "string" && typeof projectid == "string") {
                newcall.projectid = projectid;
                newcall.recordid = recordid;
            }

            return newcall;
        },

        isInInterview: function () {
            return this.m_bInInterview;
        },


        isInCall: function ()
        {
            return this.m_bInCall;
        },

        callDropped: function ( disconnectedLine ) {
            
            //
            //  Si nous ne sommes plus en appel , le callback de fin d'appel n'est pas appelle
            //
            if (this.m_bInCall == false)
                return;

            MEDIARequest.reset();

            //
            //  Si nous sommes victime du crossdomain nous envoyons un interview complete sur la reponse
            //  de la commande hangup avec un last call = true
            //
            CrossDomainInfo.sendInterviewComplete();

            if (typeof this.m_onCallDrop == "function")
                this.m_onCallDrop(disconnectedLine);

            if( this.isRepondentLine(disconnectedLine) == true ) {
                this.m_bInCall = false;
            }
        },

        Get: function (szName, szDefault) {

            if (typeof this.m_Parser != "object" || this.m_Parser == null)
                return szDefault;

            return this.m_Parser.getParameter(szName, szDefault);
        },

        //
        //  Par default la requete wait retourne apres 4 minutes meme si nous n'avons pas recu d'appels
        //  Si aucun argument nous considerons que la command wait nous est retourne apres l'expiration
        //  donc pas un nouvel appel
        //  
        //
        isNewCall: function() {

            var bNewCall = false;
            if (typeof this.m_Parser == "object" && this.m_Parser != null )
                bNewCall = this.m_Parser.getArgument().length == 0 ? false : true

            return bNewCall;
        },

        isStatus: function (szStatus) {

            if (typeof this.m_Parser != "object" || this.m_Parser == null)
                return "";

            return this.m_Parser.isStatus(szStatus);
        },

        getError: function () {
            return this.m_szError;
        },

        isParsingError: function(){
            return  this.m_szError.length == 0 ? false : true ;
        },

        error: function (message) {
            CallClass.m_szError = message;
            return ;
        },

        reset: function () {
            this.m_szError = "";
            this.m_Parser = null;
            this.m_bInCall = false;
            this.m_InboundParameterList =  "" ;
            this.m_InboundParametersValue = "";
        }
    }

//
//      Cette classe permet:
//
//          1) De de remettre voxco.agent sur pied lorsque le crossdomain est detecte
//          2) Envoyer un interview complete pour completer l'intrevue. 
//          3) Mettre l'entrevue en last call ( pause_time = 0 )
//          4) Aficher un message pour avertir l'agent de la situation.
//

    var CrossDomainInfo = {

        //
        //  m_szVoxcoAgentUrl   : url de voxco.agent
        //  m_szIntwebUrl       : url de IntWeb
        //  m_szProjectName     : Nom du projet sur lequel l'agent travail
        //  m_szAgentId         : id de l'agent
        //  m_szModuleId        : id du module Pronto
        //  m_szMessage         : message  affiche a l'ecran
        //  m_headerFrame       : le frame header
        //  m_bAlertSent        : Alert afficher
        //
        //
        //
        m_szVoxcoAgentUrl: "",
        m_szIntwebUrl: "",
        m_szProjectName: "",
        m_szAgentId: "",
        m_szUserName: "",
        m_szModuleId: "",
        m_szMessage: "",
        m_szProjectType: "",
        m_bAlertSent: false,
        m_bCrossDomain: false ,
        m_bAlertDisplayed: false ,
        m_szParameter: "NAME='PAUSE_TIME',VALUE='0.00'",



        init: function () {
            return;
        },

        Reset: function () {

            this.m_szVoxcoAgentUrl = "";
            this.m_szIntwebUrl = "";
            this.m_szProjectName = "";
            this.m_szAgentId = "";
            this.m_szUserName = "";
            this.m_szModuleId = "";
            this.m_szMessage = "";
            this.m_bAlertSent = false;
            this.m_bCrossDomain = false;
        },

        VerifyCrossDomain: function (catiUrl) {

            var voxcoAgentUrl = $.url();
            var _cati = $.url(catiUrl);

            var _voxcoAgentHost = $.url().attr('host');
            var _CatiHost = _cati.attr('host');

            _voxcoAgentHost = _voxcoAgentHost.toLowerCase();
            _CatiHost = _CatiHost.toLowerCase();

            var bCrossDomain = true;
            if ((voxcoAgentUrl.attr('protocol') === _cati.attr('protocol')) && (_voxcoAgentHost === _CatiHost)) {
                bCrossDomain = false;
            }

            return bCrossDomain;
        } ,


        isCrossDomain: function (bReset) {

            if (typeof bReset != "boolean")
                bReset = true;


            var bCrossDomain = this.m_bCrossDomain;
            if ( bReset == true)
                this.Reset();

            return bCrossDomain;
        },

        //
        //  CrossDomainInfo.hideAlert 
        //
        //      On retire le message a l'ecran
        //

        hideAlert: function () {

            if (typeof this.m_headerFrame != "object")
                return;

            if (this.m_bAlertDisplayed == false)
                return;

            this.m_bAlertDisplayed = false;
            try {

                var txt = context.document.getElementById("errorMessageTxt");
                txt.innerHTML = "" ;

                span = this.m_headerFrame.document.getElementById("error-message");
                span.style.display = 'none';
            }
            catch( e ){

            }
            return;
        },

        //
        //  CrossDomainInfo.displayAlert
        //
        //  Affichage du message a l'entete de l'application Voxco.Agent
        //
        displayAlert: function (message , context) {

            if (typeof context != "object")
                return;

            if (typeof message != "string")
                return;

            if (this.m_bAlertDisplayed == true)
                return;

            try {
             
                this.m_bAlertDisplayed = true;
                var txt = context.document.getElementById("errorMessageTxt");
                txt.innerHTML = message + this.m_szIntwebUrl;

                var display = context.document.getElementById("error-message");
                display.style.display = 'inline'
            }
            catch( e ) {

            }
          
        },

        //
        //  CrossDomainInfo.sendInterviewComplete
        //
        //  Dans les cas de CrossDomain Voliation Policy,  nous envoyons un interview complete pour terminer l'appel de l'agent.
        //  Comme l'interview complete est un MASK appartenant au document intweb, il
        //  il nous est impossible de lire de MASK 
        //
        sendInterviewComplete: function () {

            if (this.isCrossDomain( false ) == true )
            {
                //
                //  Envoie de l'interview complete et nous mettons l'agent en last call .
                //
                this.hideAlert();
                AgentAssignment.setLastCall(true, "sendInterviewComplete");
                ICRequest.addParameter(this.m_szParameter);
                ICRequest.execute( this.m_szProjectType , this.m_szAgentId);
            }

            //this.Reset();
            return;
        },

        Alert: function (message) {

            if (this.m_bAlertSent == false)
            {
                DialogBox.CrossDomainPolicy(message + " " + this.m_szIntwebUrl);
                m_bAlertSent = true;
            }
        },

        getIntwebUrl: function () {
            var url = this.m_szIntwebUrl;
            this.Reset();
            return url;
        }

    }


    //
    //  Commande Interview complete 
    //
    var ICRequest = {

        m_iNbError: 0 ,
        m_State   : { Complete:false , userid:0}   ,
        m_Url     : this.location.protocol + "//" + this.location.hostname + "/Voxco.Agent.WebService/PHService.asmx" ,
        m_Method  : "post" ,
        m_StartTime: null,
        m_ProjectType: 0,
        m_ICDelay: 3.0 ,
        m_szName      : "INT_COMPLETE" ,
        m_Parameters: "",
        m_szErrorType : CommandErrorType.success ,
        m_szErrorMsg  : "" ,
        m_bLastcall: false,
        m_bPureCati : false ,
        m_Parser: null,
        m_Chronometer:null ,
        m_UserId: 0,
        m_bICMaskFound: false,
        m_Callback: { onDisplayAlert: null, onLog: null, onSuccess: null, onExecute: null, onNetworkError: null },

        init: function( callback ){

            this.m_Chronometer = new Chronotimer("ICRequest", "delay", this.debug);

            //
            //  onExecute       ->    appeler avant l'envoie de la requette
            //  onLog           ->    pour les traces 
            //  onSuccess       ->    Appeler lorsque nous avons recus la reponses du serveur
            //  onNetworkError  ->    appeler lorsque nous avons des problemes reseaux ou http
            //

            if (typeof callback != "object")
                return;

            if (typeof callback.onDisplayAlert == "function")
                this.m_Callback.onDisplayAlert = callback.onDisplayAlert;

            if (typeof callback.onExecute == "function")
                this.m_Callback.onExecute = callback.onExecute;

            if (typeof callback.onLog == "function")
                this.m_Callback.onLog = callback.onLog;

            if (typeof callback.onSuccess == "function" )
                this.m_Callback.onSuccess = callback.onSuccess;

            if (typeof callback.onNetworkError == "function")
                this.m_Callback.onNetworkError = callback.onNetworkError;
        },

        execute: function (projectType, userid, bPureCati) {

            this.m_ProjectType        = projectType ;
            this.m_UserId             = userid ;
            this.m_StartTime          = new Date();
            this.m_State.Complete     = false;


            if (typeof bPureCati == "boolean" && bPureCati == true) {

                if (typeof this.m_Callback.onSuccess == "function") {
                    var parser = new ResponseParser(ICRequest.m_szName, "INT_COMPLETE//OK", ICRequest.error);
                    this.m_Callback.onSuccess(parser);
                }
            }
            
            if (this.isLastCall() == true) {
                //
                //  Au demarre le chronometre du pause pour les statistiques d'agent
                //
                PAUSERequest.startChronometer();
            }

            //
            //  L'appel est termine . Dans le code de voxco.agent nous utilise cette variable pour des fins de logiques.
            //
            
            CallClass.reset();
            MEDIARequest.stop(true);
            MUTERequest.resetState();
            CallStats.callEnd();
      
            GETMessage.setIdleTimeout();
            //
            //  Appel voxco.agent pour initialser ces millions de variables.
            //
            if (typeof this.m_Callback.onExecute == "function")
                this.m_Callback.onExecute();

            this.debug("ICRequest.execute> sending interview complete to telephony server...Parameters: " + this.m_Parameters);

            var webservice = new SOAPWebServiceCall(this.m_szName, this.m_Url, "ExecProntoCommand",  this.error, this.debug);
            webservice.setParams(new Array('_userId', this.m_UserId, '_command', this.m_szName, '_pairParams', this.m_Parameters));
            webservice.execute(this.onResponse);
        },

        getICDelay: function( factor )
        {
            if (typeof factor != "number" || factor == 0)
                return this.m_ICDelay;

            return this.m_ICDelay * factor;
        },


        setICDelay: function (ICDelay) {

            try{
                this.m_ICDelay = parseFloat(ICDelay);
            }
            catch( e ){
                this.m_ICDelay = 3.0;
            }
          
            return this.m_ICDelay;
        },

        isMaskFound: function () {
            return this.m_bICMaskFound;
        },

        setMaskFound: function () {
            this.m_bICMaskFound = true;
        },


        stopDelayTime: function () {
            return this.m_Chronometer.Stop();
        },

        startDelayTime: function () {
            return this.m_Chronometer.Start();
        },


        getDelayTime: function( bReset ){

            if (typeof this.m_Chronometer != "object")
                return 0;

            var elapsetime = this.m_Chronometer.Get();
            if (typeof bReset == "boolean" && bReset == true) {
                CallStats.addDelayTime(this.m_Chronometer, true );
                elapsetime = this.m_Chronometer.Reset();
            }

            return elapsetime;
        },

        addParameter: function( parameter ){

            if( typeof parameter == "undefined" || typeof parameter != "string" || parameter == null )
                return ;

            this.m_Parameters = parameter ;
        },


        concatParameter: function (name, value) {

            if( this.m_Parameters.length == 0 )
                this.m_Parameters = "NAME=" + "'" + name + "'" + ",VALUE='" + value + "'";
            else 
                this.m_Parameters += ",NAME=" + "'" + name + "'" + ",VALUE='" + value + "'";
        },

        setLastCall: function (bLastCall , szCalling) {

            if (bLastCall != this.m_bLastcall) {
                this.debug("setLastCall> setting last call to " + bLastCall + " from function " + szCalling);
                this.m_bLastcall = bLastCall;
            }

            return this.m_bLastcall;
        },

  
        name: function(){
            return this.m_szName;
        },

        //
        //  Nous avons recus une reponse du serveur.
        //
        onResponse: function (bResult, webservice, error, httpstatus ) {

            CallClass.setInInterview(false);
            CallClass.callDropped(CallClass.Get("LINE"));
            if (bResult == false) {

                //
                //  Probleme reseau ou exeception java script -- 911 
                //  Pour libere le callback de la requete HTTP nous demarrons un timer pour le re-envoie de la
                //  requete.
                //
           
                webservice = null;
                setTimeout(function () { ICRequest.executeOnNetworkError(error, httpstatus); }, 100);
                return;
            }

            if (ICRequest.isLastCall() == false)
                ICRequest.startDelayTime();

            ICRequest.debug("ICRequest.onResponse> Just received interview complete response from the server --  " + arguments[2]);

            ICRequest.m_szErrorType = CommandErrorType.request;
            ICRequest.m_State.Complete = true;
            ICRequest.m_Parser = new ResponseParser(ICRequest.m_szName, arguments[2], ICRequest.error);
            ICRequest.m_Parser.parse();

            if( ICRequest.m_Parser.isStatus( "ERR" ) == true )
                ICRequest.m_szErrorType = CommandErrorType.request ;
        
            //
            //  Le onsucces est appele dans tous les cas meme si les serveurs nous reviennent avec une erreur controle
            //
            if (ICRequest.m_Callback.onSuccess != null)
                ICRequest.m_Callback.onSuccess(ICRequest.m_Parser);
    
            DialogBox.enableShowAlert(false);
            ICRequest.reset();
            return;
        } ,

        GenerateInterviewComplete: function ( CmdManager ) {

            //
            // Le mask a ete trouve ... pas besoin de le generer
            //
            if (this.isMaskFound() == true)
                return;

            if (typeof CmdManager != "object")
                return;

            if (WAITRequest.isWaitInProgress() == true || CallClass.isInCall() == true) {
                this.error("GenerateInterviewComplete> No interview complete mask found in the call back page but the agent is waiting: " + WAITRequest.isWaitInProgress() + " or  he is in call " + CallClass.isInCall());
                return;
            }


            try {
                this.error("GenerateInterviewComplete> No interview complete mask found in the call back page. Trying to generate one on the fly");
                var prontoCmdParam = "NAME='PAUSE_TIME',VALUE='" + "3.00" + "'";
                CmdManager.insertCmd("INT_COMPLETE", prontoCmdParam);
                setTimeout("executeProntoCommand();", 1);
            }
            catch (e) {

            }

            return;
        },


        warning: function (szMessage) {

            ConsoleDebug._warning(szMessage);

            ICRequest.m_szErrorMsg = szMessage;
            if (typeof ICRequest.m_Callback.onLog != "function")
                return;

            ICRequest.m_Callback.onLog(LogLevel.warning, szMessage);
            return;
        },

        sanityCheck: function (message) {

            //
            // Protege par un try and catch. Si l'exception n'est pas attrape a ce niveau nous
            // risquons de creer une boucle infini avec le onMainLoad de closeSentinel.aspx
            //
            try {
                if (this.m_bICMaskFound == false)
                    return;

                this.warning(message);
            }
            catch (e) {

            }
           
            return;
        },
        
        //
        //  Nous avons eu un probleme reseau ou un probleme http ( 500 , 503 et autres )
        //
        executeOnNetworkError: function( error , httpstatus ){

            //
            //
            //  Sur les erreurs reseaux nous revoyons la requete . Si le code 911 , nous avons eu un probleme interne avec
            //  le javascript
            //

           

            if (ICRequest.m_iNbError > 3 || httpstatus == 911) {

                ICRequest.m_szErrorType = CommandErrorType.network ;
                if (httpstatus == 911)
                    ICRequest.m_szErrorType = CommandErrorType.javascriptexecption;

                ICRequest.onError( error );
                ICRequest.m_State.Complete = true;
                return ;
            }

            CallStats.addNetworkError();
            ICRequest.m_iNbError++;
            var webservice = new SOAPWebServiceCall(this.m_szName, this.m_Url, "ExecProntoCommand", this.error, this.debug);
            webservice.setParams(new Array('_userId', ICRequest.m_UserId, '_command', ICRequest.m_szName, '_pairParams', ICRequest.m_Parameters));
            webservice.execute(this.onResponse);
            return;
        },

        //
        //  Appeler lorsque nous avons une erreur reseau
        //
        onError: function ( error )
        {
            if (typeof error == "string")
                this.m_szErrorMsg = error;

            this.reset();

            CallStats.addNetworkError();

            if (this.m_Callback.onNetworkError != null) {
                this.m_Callback.onNetworkError(error);
                return;
            }
        },

        debug: function (message) {
            ConsoleDebug._debug(message);
        },

        error: function ( szMessage) {

            ConsoleDebug._error(szMessage);

            ICRequest.m_szErrorMsg = szMessage;
            if (typeof ICRequest.m_Callback.onLog != "function")
                return;

            ICRequest.m_Callback.onLog(LogLevel.error, szMessage);
            return;
        },
   
        getError: function( ){
            return this.m_szErrorMsg ;
        },

        getParameter: function( name , defaultvalue ){
            if( this.m_Parser == null )
                return defaultvalue ;

            return this.m_Parser.getParameter( name , defaultvalue ) ;
        },


        isLastCall: function () {
            this.debug("isLastCall> The last call state is " + this.m_bLastcall);
            return this.m_bLastcall;
        },

        isRequestComplete: function( ){
            return this.m_State.Complete;
        },

        //
        //  Calcule le delay
        //
        getInterviewCompleteDelay: function () {

            if (this.m_StartTime == null)
                return 0;

            var elapseTime   = new Date().getTime() - this.m_StartTime.getTime();
            this.m_StartTime = null;

            return elapseTime;
        },

        reset: function () {
            this.m_Parameters = "";
            this.m_szErrorMsg = "";
            this.m_iNbError = 0;
            this.m_bICMaskFound = false;
        }
    }


    var GETMessage = {

        m_iNbError: 0,
        m_State: { Complete: false, userid: 0 },
        m_Url: this.location.protocol + "//" + this.location.hostname + "/Voxco.Agent.WebService/PHService.asmx",
        m_Method: "post",
        m_StartTime: null,
        m_TimerId: 0,
        m_iIdleTimeout: 5000,
        m_iCurrentTimeout: 5000,
        m_szName: "getMessages",
        m_szErrorType: CommandErrorType.success,
        m_szErrorMsg: "",
        m_Parser: null,
        m_UserId: 0,
        m_Callback: { onDisplayAlert: null, onLog: null, onSuccess: null, onExecute: null, onNetworkError: null },

        init: function (callback ) {

            this.m_UserId = gClassManager.getConfigManager().getUserId() ;
            //
            //  onExecute       ->    appeler avant l'envoie de la requette
            //  onLog           ->    pour les traces 
            //  onSuccess       ->    Appeler lorsque nous avons recus la reponses du serveur
            //  onNetworkError  ->    appeler lorsque nous avons des problemes reseaux ou http
            //

            if (typeof callback != "object")
                return;

            if (typeof callback.onDisplayAlert == "function")
                this.m_Callback.onDisplayAlert = callback.onDisplayAlert;

            if (typeof callback.onExecute == "function")
                this.m_Callback.onExecute = callback.onExecute;

            if (typeof callback.onLog == "function")
                this.m_Callback.onLog = callback.onLog;

            if (typeof callback.onSuccess == "function")
                this.m_Callback.onSuccess = callback.onSuccess;

            if (typeof callback.onNetworkError == "function")
                this.m_Callback.onNetworkError = callback.onNetworkError;
        },

        startGetTimeout: function ()
        {
            if (this.m_TimerId != 0)
                clearTimeout(this.m_TimerId);

            this.m_TimerId = setTimeout(function () { GETMessage.execute( this.m_UserId ); }, this.m_iCurrentTimeout);
            return ;
        },

        execute: function ( userid ) {

            if (this.m_UserId == 0 )
            this.m_UserId = userid;

            this.m_StartTime = new Date();
            this.m_State.Complete = false;


            //
            //  Appel voxco.agent pour initialser ces millions de variables.
            //
            if (typeof this.m_Callback.onExecute == "function")
                this.m_Callback.onExecute();

            var webservice = new SOAPWebServiceCall(this.m_szName, this.m_Url, "AgentGetMessages", this.error, this.debug);
            webservice.setParams(new Array('_userId', this.m_UserId ));
            webservice.execute(this.onResponse);
        },

        name: function () {
            return this.m_szName;
        },

        setIncallTimeout: function (userid) {
            this.m_iCurrentTimeout = 2000;
        },

       
        setIdleTimeout: function (userid) {

            if (typeof userid != "undefined")
                this.m_UserId = userid;

            this.m_iCurrentTimeout = this.m_iIdleTimeout;
            return;
        },


        //
        //  Nous avons recus une reponse du serveur.
        //
        onResponse: function (bResult, webservice, error, httpstatus) {

            if (bResult == false) {

                //
                //  Probleme reseau ou exeception java script -- 911 
                //  Pour libere le callback de la requete HTTP nous demarrons un timer pour le re-envoie de la
                //  requete.
                //


                webservice = null;
                setTimeout(function () { GETMessage.executeOnNetworkError(error, httpstatus); }, GETMessage.m_iCurrentTimeout);
                return;
            }

            GETMessage.m_szErrorType = CommandErrorType.request;
            GETMessage.m_State.Complete = true;
            GETMessage.m_Parser = new ResponseParser(GETMessage.m_szName, "getMessages//OK;" + arguments[2], GETMessage.error);
            GETMessage.m_Parser.parse();

            if (GETMessage.m_Parser.isStatus("ERR") == true)
                GETMessage.m_szErrorType = CommandErrorType.request;

            //
            //  Le onsucces est appele dans tous les cas meme si les serveurs nous reviennent avec une erreur controle
            //
            if (GETMessage.m_Callback.onSuccess != null)
                GETMessage.m_Callback.onSuccess(GETMessage.m_Parser);


            GETMessage.reset();
            GETMessage.startGetTimeout();
            return;
        },

        Stop: function()
        {
            if (this.m_TimerId != 0) {
                clearTimeout(this.m_TimerId);
                this.m_TimerId = 0;
            }
        },

        //
        //  Nous avons eu un probleme reseau ou un probleme http ( 500 , 503 et autres )
        //
        executeOnNetworkError: function (error, httpstatus) {

            //
            //
            //  Sur les erreurs reseaux nous revoyons la requete . Si le code 911 , nous avons eu un probleme interne avec
            //  le javascript
            //

          
            if (GETMessage.m_iNbError > 3 || httpstatus == 911) {

                GETMessage.m_szErrorType = CommandErrorType.network;
                if (httpstatus == 911)
                    GETMessage.m_szErrorType = CommandErrorType.javascriptexecption;

                GETMessage.onError(error);
                GETMessage.m_State.Complete = true;
                return;
            }

            CallStats.addNetworkError();
            GETMessage.m_iNbError++;
            GETMessage.startGetTimeout();
            return;
        },

        //
        //  Appeler lorsque nous avons une erreur reseau
        //
        onError: function (error) {
            if (typeof error == "string")
                this.m_szErrorMsg = error;

            this.reset();
            this.startGetTimeout();

            if (this.m_Callback.onNetworkError != null) {
                this.m_Callback.onNetworkError(GETMessage.m_szName , error);
                return;
            }
        },

        debug: function (message) {
            ConsoleDebug._debug(message);
        },

        error: function (szMessage) {

            ConsoleDebug._error(szMessage);

            GETMessage.m_szErrorMsg = szMessage;
            if (typeof GETMessage.m_Callback.onLog != "function")
                return;

            GETMessage.m_Callback.onLog(LogLevel.error, szMessage);
            return;
        },

        getError: function () {
            return this.m_szErrorMsg;
        },

        getParameter: function (name, defaultvalue) {
            if (this.m_Parser == null)
                return defaultvalue;

            return this.m_Parser.getParameter(name, defaultvalue);
        },

        isRequestComplete: function () {
            return this.m_State.Complete;
        },

        reset: function () {
            this.m_szErrorMsg   = "";
            this.m_iNbError     = 0;
        }
    }



    var SIGNOff = {

        m_iNbError: 0,
        m_State: { Complete: false, userid: 0 },
        m_Url: this.location.protocol + "//" + this.location.hostname + "/Voxco.Agent.WebService/PHService.asmx",
        m_Method: "post",
        m_StartTime: null,
        m_bSignoff: false ,
        m_szName: "signoff",
        m_szErrorType: CommandErrorType.success,
        m_szErrorMsg: "",
        m_Parameters: { _userid:0 , _workStationId:0, _sessId:"" , _badClosing:false},
        m_Parser: null,
        m_UserId: 0,
        m_Callback: { onDisplayAlert: null, onLog: null, onSuccess: null, onExecute: null, onNetworkError: null },

        init: function (callback) {

            //
            //  onExecute       ->    appeler avant l'envoie de la requette
            //  onLog           ->    pour les traces 
            //  onSuccess       ->    Appeler lorsque nous avons recus la reponses du serveur
            //  onNetworkError  ->    appeler lorsque nous avons des problemes reseaux ou http
            //

            if (typeof callback != "object")
                return;

            if (typeof callback.onDisplayAlert == "function")
                this.m_Callback.onDisplayAlert = callback.onDisplayAlert;

            if (typeof callback.onExecute == "function")
                this.m_Callback.onExecute = callback.onExecute;

            if (typeof callback.onLog == "function")
                this.m_Callback.onLog = callback.onLog;

            if (typeof callback.onSuccess == "function")
                this.m_Callback.onSuccess = callback.onSuccess;

            if (typeof callback.onNetworkError == "function")
                this.m_Callback.onNetworkError = callback.onNetworkError;
        },

  
        execute: function (parameters) {

            if( typeof parameters == "object" )
                this.m_Parameters = parameters;

            if (this.m_bSignoff == true) {
                this.debug("SIGNOff.execute> the agent is already loggoff...");
                return;
            }

            this.m_StartTime        = new Date();
            this.m_State.Complete = false;
            this.m_bSignoff = true;

            //
            //  Appel voxco.agent pour initialser ces millions de variables.
            //

            if (typeof this.m_Callback.onExecute == "function")
                this.m_Callback.onExecute();

            var webservice = new SOAPWebServiceCall(this.m_szName, this.m_Url, "AgentSignOff", this.error, this.debug);
            webservice.setParams(new Array('_userId', this.m_Parameters._userid, "_workStationId", this.m_Parameters._workStationId , "_sessId", this.m_Parameters._sessId, "_badClosing",this.m_Parameters._badClosing));
            webservice.execute(this.onResponse);
        },

        isSignoff: function() {
            return this.m_bSignoff ;
        },

        name: function () {
            return this.m_szName;
        },

        //
        //  Nous avons recus une reponse du serveur.
        //
        onResponse: function (bResult, webservice, error, httpstatus) {

            if (bResult == false) {

                //
                //  Probleme reseau ou exeception java script -- 911 
                //  Pour libere le callback de la requete HTTP nous demarrons un timer pour le re-envoie de la
                //  requete.
                //


            
                return;
            }


            var response = SIGNOff.m_szName + "//" + arguments[2];
            SIGNOff.debug("SIGNOff.onResponse> Just received signoff response from the server --  " + response);

            SIGNOff.m_szErrorType = CommandErrorType.request;
            SIGNOff.m_State.Complete = true;
            SIGNOff.m_bSignoff = true;
            SIGNOff.m_Parser = new ResponseParser(SIGNOff.m_szName, response, SIGNOff.error);
            SIGNOff.m_Parser.parse();

            if (SIGNOff.m_Parser.isStatus("ERR") == true)
                SIGNOff.m_szErrorType = CommandErrorType.request;

            //
            //  Le onsucces est appele dans tous les cas meme si les serveurs nous reviennent avec une erreur controle
            //
            if (SIGNOff.m_Callback.onSuccess != null)
                SIGNOff.m_Callback.onSuccess(SIGNOff.m_Parser);


            SIGNOff.reset();
            return;
        },

   
        //
        //  Nous avons eu un probleme reseau ou un probleme http ( 500 , 503 et autres )
        //
        executeOnNetworkError: function (error, httpstatus) {

            //
            //
            //  Sur les erreurs reseaux nous revoyons la requete . Si le code 911 , nous avons eu un probleme interne avec
            //  le javascript
            //



            SIGNOff.m_bSignoff = false;
            if (SIGNOff.m_iNbError > 3 || httpstatus == 911) {

                SIGNOff.m_szErrorType = CommandErrorType.network;
                if (httpstatus == 911)
                    SIGNOff.m_szErrorType = CommandErrorType.javascriptexecption;

                SIGNOff.onError(error);
                SIGNOff.m_State.Complete = true;
                return;
            }

            CallStats.addNetworkError();
            SIGNOff.m_iNbError++;

            var webservice = new SOAPWebServiceCall(SIGNOff.m_szName, SIGNOff.m_Url, "AgentSignOff", SIGNOff.error, this.debug);
            webservice.setParams(new Array('_userId', SIGNOff.m_Parameters._userid, "_workStationId", SIGNOff.m_Parameters._workStationId , "_sessId", SIGNOff.m_Parameters._sessId, "_badClosing",SIGNOff.m_Parameters._badClosing));
            webservice.execute(this.onResponse);
            return;
        },

        //
        //  Appeler lorsque nous avons une erreur reseau
        //
        onError: function (error) {
            if (typeof error == "string")
                this.m_szErrorMsg = error;

            this.reset();
   
            if (this.m_Callback.onNetworkError != null) {
                this.m_Callback.onNetworkError(error);
                return;
            }
        },

        debug: function (message) {
            ConsoleDebug._debug(message);
        },

        error: function (szMessage) {

            ConsoleDebug._error(szMessage);
            SIGNOff.m_szErrorMsg = szMessage;
            if (typeof SIGNOff.m_Callback.onLog != "function")
                return;

            SIGNOff.m_Callback.onLog(LogLevel.error, szMessage);
            return;
        },

        getError: function () {
            return this.m_szErrorMsg;
        },

        getParameter: function (name, defaultvalue) {
            if (this.m_Parser == null)
                return defaultvalue;

            return this.m_Parser.getParameter(name, defaultvalue);
        },

        isRequestComplete: function () {
            return this.m_State.Complete;
        },


        getRequestParameter: function() {
            return this.m_Parameters ;
        },

        setRequestParameter: function ( parameter ){
            m_Parameters = parameter ;
            return
        },

        reset: function () {
            this.m_szErrorMsg = "";
            this.m_iNbError = 0;
        }
    }



    var TransferIVRRequest = {

        m_iNbError: 0,
        m_State: { Complete: false, userid: 0 },
        m_Url: this.location.protocol + "//" + this.location.hostname + "/Voxco.Agent.WebService/PHService.asmx",
        m_Method: "post",
        m_StartTime: null,
        m_szName: "TRANSFER_IVR",
        m_szErrorType: CommandErrorType.success,
        m_szErrorMsg: "",
        m_Parser: null,
        m_UserId: 0,
        m_Callback: { onDisplayAlert: null, onLog: null, onSuccess: null, onExecute: null, onNetworkError: null },

        init: function (callback) {

            //
            //  onExecute       ->    appeler avant l'envoie de la requette
            //  onLog           ->    pour les traces 
            //  onSuccess       ->    Appeler lorsque nous avons recus la reponses du serveur
            //  onNetworkError  ->    appeler lorsque nous avons des problemes reseaux ou http
            //

            if (typeof callback != "object")
                return;

            if (typeof callback.onDisplayAlert == "function")
                this.m_Callback.onDisplayAlert = callback.onDisplayAlert;

            if (typeof callback.onExecute == "function")
                this.m_Callback.onExecute = callback.onExecute;

            if (typeof callback.onLog == "function")
                this.m_Callback.onLog = callback.onLog;

            if (typeof callback.onSuccess == "function")
                this.m_Callback.onSuccess = callback.onSuccess;

            if (typeof callback.onNetworkError == "function")
                this.m_Callback.onNetworkError = callback.onNetworkError;
        },


        execute: function (parameters, userid ) {

            if (typeof parameters != "undefined")
                this.m_Parameters = parameters;
         
            if (typeof userid != "undefined")
                this.m_UserId = userid;

            this.m_StartTime        = new Date();
            this.m_State.Complete   = false;
          
            //
            //  Appel voxco.agent pour initialser ces millions de variables.
            //

            if (typeof this.m_Callback.onExecute == "function")
                this.m_Callback.onExecute();

            var webservice = new SOAPWebServiceCall(this.m_szName, this.m_Url, "ExecProntoCommand", this.error, this.debug);
            webservice.setParams(new Array('_userId', this.m_UserId, '_command', this.m_szName, '_pairParams', this.m_Parameters));
            webservice.execute(this.onResponse);
        },


        name: function () {
            return this.m_szName;
        },

        //
        //  Nous avons recus une reponse du serveur.
        //
        onResponse: function (bResult, webservice, error, httpstatus) {

            if (bResult == false) {

                //
                //  Probleme reseau ou exeception java script -- 911 
                //  Pour libere le callback de la requete HTTP nous demarrons un timer pour le re-envoie de la
                //  requete.
                //


                webservice = null;
                setTimeout(function () { TransferIVRRequest.executeOnNetworkError(error, httpstatus); }, 100);

                return;
            }

            TransferIVRRequest.debug("TransferIVRRequest.onResponse> Just received signoff response from the server --  " + arguments[2]);
            TransferIVRRequest.m_szErrorType = CommandErrorType.request;
            TransferIVRRequest.m_State.Complete = true;
       
            TransferIVRRequest.m_Parser = new ResponseParser(TransferIVRRequest.m_szName, arguments[2], TransferIVRRequest.error);
            TransferIVRRequest.m_Parser.parse();

            if (TransferIVRRequest.m_Parser.isStatus("ERR") == true)
                TransferIVRRequest.m_szErrorType = CommandErrorType.request;
            else
                CallClass.callDropped(CallClass.Get( "LINE"));

            //
            //  Le onsucces est appele dans tous les cas meme si les serveurs nous reviennent avec une erreur controle
            //
            if (TransferIVRRequest.m_Callback.onSuccess != null)
                TransferIVRRequest.m_Callback.onSuccess(TransferIVRRequest.m_Parser);


            TransferIVRRequest.reset();
            return;
        },


        //
        //  Nous avons eu un probleme reseau ou un probleme http ( 500 , 503 et autres )
        //
        executeOnNetworkError: function (error, httpstatus) {

            //
            //
            //  Sur les erreurs reseaux nous revoyons la requete . Si le code 911 , nous avons eu un probleme interne avec
            //  le javascript
            //

            if (TransferIVRRequest.m_iNbError > 3 || httpstatus == 911) {

                TransferIVRRequest.m_szErrorType = CommandErrorType.network;
                if (httpstatus == 911)
                    TransferIVRRequest.m_szErrorType = CommandErrorType.javascriptexecption;

                TransferIVRRequest.onError(error);
                TransferIVRRequest.m_State.Complete = true;
                return;
            }

            CallStats.addNetworkError();
            TransferIVRRequest.m_iNbError++;

            var webservice = new SOAPWebServiceCall(this.m_szName, this.m_Url, "ExecProntoCommand", this.error, this.debug);
            webservice.setParams(new Array('_userId', this.m_UserId, '_command', this.m_szName, '_pairParams', this.m_Parameters));
            webservice.execute(this.onResponse);
            return;
        },

        //
        //  Appeler lorsque nous avons une erreur reseau
        //
        onError: function (error) {
            if (typeof error == "string")
                this.m_szErrorMsg = error;

            this.reset();

            if (this.m_Callback.onNetworkError != null) {
                this.m_Callback.onNetworkError(error);
                return;
            }
        },

        debug: function (message) {
            ConsoleDebug._debug(message);
        },

        error: function (szMessage) {

            ConsoleDebug._error(szMessage);

            TransferIVRRequest.m_szErrorMsg = szMessage;
            if (typeof TransferIVRRequest.m_Callback.onLog != "function")
                return;

            TransferIVRRequest.m_Callback.onLog(LogLevel.error, szMessage);
            return;
        },
  
        getError: function () {
            return this.m_szErrorMsg;
        },

    
        isRequestComplete: function () {
            return this.m_State.Complete;
        },


        getRequestParameter: function () {
            return this.m_Parameters;
        },

        setRequestParameter: function (parameter) {
            m_Parameters = parameter;
            return
        },

        reset: function () {
            this.m_szErrorMsg = "";
            this.m_iNbError = 0;
        }
    }
  
    //
    //  Command wait 
    //
    var WAITRequest ={

        m_iNbError: 0,
        m_iNbWaitRequest:0 ,
        m_WebRequest: null,
        m_bRequestCanceled : false ,
        m_Url     : this.location.protocol + "//" + this.location.hostname + "/Voxco.Agent.WebService/PHService.asmx" ,
        m_Method  : "post" ,
        m_StartTime: null,
        m_StopTime: null,
        m_szName: "wait",
        m_szErrorMsg: "",
        m_iResendWaitTimerId:0 ,
        m_szPreviousState: "" ,
        m_szSOAPMethod: "AgentWaitPolling" ,
        m_bInprogress: false,
        m_iDifferedWaitTrialCount: 0,               // Used to avoid trying to set DifferedWait to the infiny
        m_szErrorType: CommandErrorType.success ,
        m_UserId: 0,
        m_Chronometer: null,
        m_szSessionId : "" ,
        m_iTimerId: 0,
        m_Callback: { onDisplayAlert: null, onLog: null, onSuccess: null, onAssignment: null , onExecute: null, onNetworkError: null },

        init: function( callback ){

            this.m_Chronometer = new Chronotimer("WAITRequest", "waiting",  this.debug);
            if (typeof callback != "object")
                return;


            this.m_UserId = AgentAssignment.getUserId();

            //
            //  onExecute       ->    appeler avant l'envoie de la requette
            //  onLog           ->    pour les traces 
            //  onSuccess       ->    Appeler lorsque nous avons recus la reponses du serveur
            //  onNetworkError  ->    appeler lorsque nous avons des problemes reseaux ou http
            //

           
            if (typeof callback.onAssignment == "function")
                this.m_Callback.onAssignment = callback.onAssignment;

            
            if (typeof callback.onDisplayAlert == "function")
                this.m_Callback.onDisplayAlert = callback.onDisplayAlert;

            if (typeof callback.onExecute == "function")
                this.m_Callback.onExecute = callback.onExecute;

            if (typeof callback.onLog == "function")
                this.m_Callback.onLog = callback.onLog;

            if (typeof callback.onSuccess == "function" )
                this.m_Callback.onSuccess = callback.onSuccess;

            if (typeof callback.onNetworkError == "function")
                this.m_Callback.onNetworkError = callback.onNetworkError;
        },

        // WAITRequest.execute

        execute: function ( userid  ) {

            if (this.m_bInprogress == true) {

                this.debug("WAITRequest.execute> wait request already in progress...");
                return;
            }

        
            this.stopRequestTimerWait();
            this.m_iDifferedWaitTrialCount = 0;

            this.reset();

            this.m_UserId               = userid;
            this.m_bInprogress          = true;
            
            //
            //  Arret du chronometre du pause.. Nous sommes maintenant en wait 
            //

            
            DialogBox.enableShowAlert(true);
            ICRequest.stopDelayTime();
            PAUSERequest.stopChronometer();
            CrossDomainInfo.hideAlert();

            //
            //  Demarrage du chronometre pour les stats de l'agent ( waiting time )
            //
            this.m_Chronometer.Start();
            //
            //  OnExecute sert a initialiser les variables appartentant a voxco.agent avant l'envoie de la requete
            //
            if (typeof this.m_Callback.onExecute == "function")
            {
                this.m_Callback.onExecute();
            }
               

            this.debug("WAITRequest.execute> The agent is now waiting for a new. Wait button pressed");

            this.m_WebRequest = new SOAPWebServiceCall(this.m_szName, this.m_Url, this.m_szSOAPMethod, this.error, this.debug);
            this.m_WebRequest.setParams(new Array('_userId', this.m_UserId, '_sessId', this.m_szSessionId));
            this.m_WebRequest.execute(this.onResponse);

 
            //
            //  Don't check-in this... for test only
            //  Don't check-in this... for test only
            //
            //   if (this.m_iNbWaitRequest == 0)
            //       setTimeout(function () { WAITRequest.Cancel(); }, 100);
            //

  
            this.m_iNbWaitRequest++;
            return;
        },


        keepAgentExecute: function (iUserId, onExecute ) {

            if( this.m_bInprogress == true )
                this.debug("WAITRequest.execute> The agent is now waiting for a new. Wait button pressed");


        },

        Cancel: function()
        {
            if (this.m_WebRequest == null || this.m_bInprogress == false)
                return;

            this.m_bRequestCanceled = true;
            this.m_WebRequest.abort();
            return;

        },

        differedExecute: function( iUserId ){

            WAITRequest.m_iTimerId = 0 ;
            WAITRequest.execute(iUserId) ;
        },

        //
        // WAITRequest.resendWait
        //
        // Dans le design initial , le wait nous revient apres 4.30 ( minute:second ) d'inactivite pour eviter les deconnextions reseau
        // A l'expiration nous renvoyons la commande wait pour se replacer en attente.
        //
        // 
        //
        resendWait: function( timeout ){

            if (typeof timeout == "number") {

                this.stopRequestTimerWait();
                this.m_iResendWaitTimerId = setTimeout(function () { WAITRequest.resendWait() }, timeout);
                return;
            }


            if (CallClass.isInCall() == true) {
                this.error("WAITRequest.resendWait> re-sending wait is rejected because the agent is in call");
                return;
            }

            this.m_WebRequest = null;
            this.m_bInprogress = true;
            this.m_iResendWaitTimerId = 0;
            this.debug("WAITRequest.resendWait> Wait timed out... Resending wait command.");

            this.m_WebRequest = new SOAPWebServiceCall(this.m_szName, this.m_Url, 'AgentPendingCase', this.error, this.debug);
            this.m_WebRequest.setParams(new Array('_userId', this.m_UserId, '_sessId', this.m_szSessionId));
            this.m_WebRequest.execute(this.onResponse);
            return;
        },

        //
        // WAITRequest.getParameter
        //
        // A la reception de la commande wait nous recevons de l'information sur 
        // l'appel ... Cette methode permet de retourner la valeur du parametre
        // exprimer par szName 
        //
        getParameter: function (szName) {

            var szValue = "";
            szValue = CallClass.Get(szName, szValue);
            return szValue;
        },

        //
        // WAITRequest.getParameter
        //
        // A la reception de la commande wait nous recevons de l'information sur 
        // l'appel ... Cette methode permet de retourner la valeur du parametre
        // exprimer par szName 
        //

        getBoolParameter : function ( szName ) {

            var szValue = "";
            szValue = CallClass.Get(szName, szValue);
            if (szValue.length != 0) {
                szValue = szValue == '0' ? false : true;
            }

            return szValue;
        } ,

        //
        // WAITRequest.isChronoStarted
        //
        //  Est-ce que le chronometre du waitting-time est demarre
        // 
      
        
        isChronoStarted: function () {
            return this.m_Chronometer.isChronometerStarted();
        },

        //
        // WAITRequest.getWaitingTime
        //
        //  retourne la valeur du waiting-time
        // 

        getWaitingTime: function() 
        {
            return  this.m_Chronometer.Get() ;
        },

        //
        // WAITRequest.calculateWaitingTime
        //
        //  Calcule la valeur du waiting-time . Si bReset == true nous
        //  nous remettons la valeur du compteur a zero
        // 

        calculateWaitingTime: function (bReset) {

            var elapseTime = this.m_Chronometer.Calculate();
            var totaltime = this.m_Chronometer.Get();

            if (bReset == true)
                this.m_Chronometer.Reset();

            return totaltime;
        },
        
        //
        // WAITRequest.name
        //
        // Retourne le nom de la commande
        //  
        // 

        name: function(){
            return this.m_szName;
        },


        //
        // WAITRequest.isErrorSet
        //
        // Est-ce que la commande nous ai revenu avec une erreur
        //  
        // 

        isErrorSet: function (error) {

            var bSet = false;
            var value = CallClass.Get("ERR");
            if( value == error )
                bSet = true;

            return bSet;
        },

        isStatusSet: function (szStatus) {
            return CallClass.isStatus(szStatus);
        },
  

        //
        // WAITRequest.onResponse
        //
        // Traitement de la reception de la reponse du systeme distant. Le travail de
        // cette methode :
        //
        //  1) decortiquer le contenue de la reponse et place les variables dans
        //     une classe structuree
        //
        //  2) Detection des erreurs reseau ou ajax ( executeOnNetworkError ). Pour liberer
        //     la ressource AJAX , nous demarrons un timer
        //
        //  3) appeler un callback pour le traitement de la reponse.
        //  
        // 

        onResponse: function (bRequestSuccess, webservice, error, httpstatus ) {
        
            WAITRequest.m_bInprogress = false;
            WAITRequest.m_WebRequest = null;

            if ( bRequestSuccess == false ) {
                webservice = null;
                setTimeout(function () { WAITRequest.executeOnNetworkError(error, httpstatus); }, 50);
                return;
            }

            //
            //  Arrete du timer ... au cas ou
            //

            WAITRequest.stopRequestTimerWait();
     
            //
            //  On standardise le format du message pour avoir une constance . Normalement ca
            //  devrait etre fait au niveau de voxco.agent.webservice mais malheureusement ce n'est
            //  pas le cas. Si changement il y a effectuer une recherche sur TODO:voxco.agent.webservice
            //
            //  TODO:voxco.agent.webservice; standartisation des reponse -> cmd//status; name:value ; name:value 
            //

            arguments[2] = WAITRequest.m_szName + "//" + arguments[2];
            WAITRequest.debug("WAITRequest.onResponse> The wait request just came back -- " + arguments[2]);

            //
            //  Creation de l'objet parser... un nouveau a chaque requete.
            //

            CallClass.Parse(WAITRequest.m_szName, ";", arguments[2], WAITRequest.error);
            WAITRequest.m_Chronometer.Calculate();

            try {

                //
                //  Si le callback nous revient avec success nous remettons le compteur
                //  waiting-time a 0. Nous ne sommes plus en wait
                //
                if (WAITRequest.m_Callback.onSuccess != null) {
                    var bNewCall = WAITRequest.m_Callback.onSuccess(CallClass.getParser());
                    if (bNewCall == true) {
                        CallStats.addWaitTime(WAITRequest.m_Chronometer, true);
                        WAITRequest.m_Chronometer.Reset();
                        GETMessage.setIncallTimeout();
                    }
                }
            }
            catch (e) {
                //
                //  Ca sent mauvais....
                //
                var message = "Wait command caught an exception -- error: " + e.message;
                setTimeout(function () { WAITRequest.onError(message); }, 1);
            }

            return;
        },

      
        //
        // WAITRequest.getParameterListName
        //
        //  Retourne la liste des noms des variables en inbound
        //
        getParameterListName: function () {
            return CallClass.getInboundParameterListName();
        },

        //
        // WAITRequest.getParameterListValue
        //
        //  Retourne la liste des valeurs associes au variable en inbound
        //
        getParameterListValue: function () {
            return CallClass.getInboundParameterListValue();
        },

        //
        // WAITRequest.isWaitInProgress
        //
        // Est-ce
        //
        isWaitInProgress: function(){
            return this.m_bInprogress ;
        },


        isInInterview: function(){

            var bInterview = true ;
            if (CallClass.isInCall() == false || this.isWaitInProgress() == true)
                bInterview = false;

            return bInterview;
        },
        
        isNewCall: function (){
            return CallClass.isNewCall();
        } ,


        keepPreviousState: function( state ){
            this.m_szPreviousState  = state ;
        },

        getPreviousState: function () {
            return this.m_szPreviousState;
        },

        differedWait: function( userid , delay, context ) {

            if (WAITRequest.m_iTimerId != 0) {
                clearTimeout(WAITRequest.m_iTimerId);
                this.m_iTimerId = 0;
            }

            switch (context) {

                case "switchProject":
                    // DE17789 - Multi Project (multi session)- Voxco.Agent not in wait state after project switch
                    // To prevent timing issue during project switch in multi project, the differedWait is delayed 
                    // until the current wait is terminate (received the Wait response)

                    if (WAITRequest.m_bInprogress == true && WAITRequest.m_iDifferedWaitTrialCount <= 100) {
                        WAITRequest.m_iDifferedWaitTrialCount = WAITRequest.m_iDifferedWaitTrialCount + 1;
                        setTimeout(function () { WAITRequest.differedWait(userid, delay, "switchProject"); }, 500);
                        return;
                    }
                    break;

                case "interviewComplete":
                default:
                    break;

            }

            WAITRequest.debug("WAITRequest.differedWait> The wait request will be sent in " + delay + " seconds at trial # " + WAITRequest.m_iDifferedWaitTrialCount);
            WAITRequest.m_iTimerId = setTimeout(function () { WAITRequest.differedExecute(userid); }, delay);
        },

        stopRequestTimerWait: function () {

            //
            //  Timer associer au wait automatique . Lorsque l'appel est complete 
            //  Voxco.agent a la responsabilite de mettre l'agent en wait apres X 
            //  secondes
            //
            if (this.m_iTimerId != 0) {
                this.debug("WAITRequest> stopping automatic wait because someone press the wait button...");
                clearTimeout(this.m_iTimerId);
                this.m_iTimerId = 0;
            }

            //
            //  Timer au re-send du wait lorsque nous revient apres X minutes sans recevoir
            //  d'appel
            //
            if (this.m_iResendWaitTimerId != 0) {
                this.debug("WAITRequest> stopping re-send wait. This timer only set after a wait timeout....");
                clearTimeout(this.m_iResendWaitTimerId);
                this.m_iResendWaitTimerId = 0;
            }
        },

        executeOnNetworkError: function( error , httpstatus ){

            if (WAITRequest.m_bRequestCanceled == true)
            {
                WAITRequest.m_bRequestCanceled = false;
                return;
            }
            

            WAITRequest.m_szErrorType = CommandErrorType.network;
            if (httpstatus == 911)
                WAITRequest.m_szErrorType = CommandErrorType.javascriptexecption;

            //
            //  TODO Si necessaire mettre en place un mecanique de reassaie si nous avons des erreurs de transmission
            //  reseau ( command Wait ) . Voir ICRequest comme exemple
            //

            CallStats.addNetworkError();
            WAITRequest.onError(error);
            WAITRequest.m_iNbError++;
        },

        onError: function ( error )
        {
            if (typeof error == "string")
                WAITRequest.m_szErrorMsg = error;

            ConsoleDebug._error(error);

            if (WAITRequest.m_Callback.onNetworkError != null) {
                WAITRequest.m_Callback.onNetworkError(WAITRequest.m_szName, error);
                return;
            }
        },

        debug: function (message) {

            ConsoleDebug._debug(message);

            if (typeof WAITRequest.m_Callback.onLog == "function")
                WAITRequest.m_Callback.onLog(LogLevel.debug, message);
        },

        error: function ( szMessage) {

            ConsoleDebug._error(szMessage);
                
            WAITRequest.m_szErrorMsg = szMessage;
            if (typeof WAITRequest.m_Callback.onLog != "function")
                return;

            WAITRequest.m_Callback.onLog(LogLevel.error, szMessage);
            return;
        },
   
        getError: function( ){
            return this.m_szErrorMsg ;
        },

        reset: function () {

            CallClass.reset();
            this.m_szErrorMsg           = "";
            this.m_iNbError             = 0;
            this.m_iResendWaitTimerId   = 0;
            this.m_iTimerId = 0;
            this.m_WebRequest = null;
        }
    }

    var PAUSERequest = {


        m_iNbError: 0,

        m_Url: this.location.protocol + "//" + this.location.hostname + "/Voxco.Agent.WebService/PHService.asmx",
        m_Method: "post",
        m_StartTime: null,
        m_szName: "pause",
        m_szErrorMsg: "",
        m_szSOAPMethod: "AgentPause",
        m_szErrorType: CommandErrorType.success,
        m_Parser: null,
        m_szPreviousState: "" ,
        m_bInprogress: false,
        m_UserId: 0,
        m_Chronometer: null,
        m_Callback: { onDisplayAlert: null, onLog: null, onSuccess: null, onExecute: null, onNetworkError: null },

        init: function (callback) {

            this.m_Chronometer = new Chronotimer("PAUSERequest", "pausing",  this.debug);
           
            if (typeof callback != "object")
                return;

            //
            //  onExecute       ->    appeler avant l'envoie de la requette
            //  onLog           ->    pour les traces 
            //  onSuccess       ->    Appeler lorsque nous avons recus la reponses du serveur
            //  onNetworkError  ->    appeler lorsque nous avons des problemes reseaux ou http
            //

            //
            //  Au moment initial nous demarrons le chronometre du pause. Il est arrete par la button
            //

          

            if (typeof callback.onDisplayAlert == "function")
                this.m_Callback.onDisplayAlert = callback.onDisplayAlert;

            if (typeof callback.onExecute == "function")
                this.m_Callback.onExecute = callback.onExecute;

            if (typeof callback.onLog == "function")
                this.m_Callback.onLog = callback.onLog;

            if (typeof callback.onSuccess == "function")
                this.m_Callback.onSuccess = callback.onSuccess;

            if (typeof callback.onNetworkError == "function")
                this.m_Callback.onNetworkError = callback.onNetworkError;
        },

        execute: function (userid) {

    
            if (PAUSERequest.m_bInprogress == true)
                return;

            this.reset();

            this.m_UserId = userid;
            this.m_StartTime = new Date();
            this.m_bInprogress = true;

            //
            //  OnExecute sert a initialiser les variables appartentant a voxco.agent avant l'envoie de la requete
            //


            this.m_Chronometer.Start();

            if (typeof this.m_Callback.onExecute == "function")
                this.m_Callback.onExecute();

            this.debug("PAUSERequest.execute> Sending pause request to web service...");

            var webservice = new SOAPWebServiceCall(this.m_szName, this.m_Url, this.m_szSOAPMethod, this.error, this.debug);
            webservice.setParams(new Array('_userId', this.m_UserId, '_sessId', ''));
            webservice.execute(this.onResponse);
        },

        name: function () {
            return this.m_szName;
        },


        isErrorSet: function (error) {

            var bSet = false;
            var value = this.m_Parser.getParameter("ERR");
            if (value == error)
                bSet = true;

            return bSet;
        },

        isStatusSet: function (szStatus) {
            return this.m_Parser.isStatus(szStatus);
        },

        startChronometer: function (bReset) {

            if (typeof this.m_Chronometer != "object")
                return 0;

            if (typeof bReset == "boolean" && bReset == true) {

                //
                //  Le temps d'attente entre deux projets n'est pas compte dans les statistiques de centre d'appel
                //
                //  le cas typique :
                //
                //      L'agent termine son appel avec last call ou appuye sur pause. Demeure dans
                //      cet etat pour une periode X. Il appuie sur la bouton selection de project et choisi un
                //      autre projet.Ce temps d'attente n'est pas comptabilise
                //
                //   Nous tracons le temps si et seulement si il est superieur a 120 secondes
                //
                //

                this.m_Chronometer.Stop();
                var elapseTime = this.m_Chronometer.Reset();
                if (elapseTime > 120 )
                    this.warning("PAUSERequest.startChronometer> The agent migth have waited  " + elapseTime + " secs between project selection. This pause time migth affect the call center productivity if occured to many time during the day...");
            }

            this.m_Chronometer.Start();
        },

        stopChronometer: function (bReset) {

            if (typeof this.m_Chronometer != "object")
                return 0;

            var elapsetime = this.m_Chronometer.Stop();
            return elapsetime;
        },

        getPauseTime: function (bReset) {

            if( typeof this.m_Chronometer != "object" )
                return 0 ;

            var elapsetime = this.m_Chronometer.Get() ;
            if (typeof bReset == "boolean" && bReset == true) {
                CallStats.addPauseTime(this.m_Chronometer, true );
                elapsetime = this.m_Chronometer.Reset();
            }

            return elapsetime ;
        },

        onResponse: function (bRequestSuccess, webservice, error, httpstatus) {

            PAUSERequest.m_bInprogress = false;

            if (bRequestSuccess == false) {

                webservice = null;
                setTimeout(function () { PAUSERequest.executeOnNetworkError(error, httpstatus); }, 50);
                return;
            }

      
            //
            //  On standardise le format du message pour avoir une constance . Normalement ca
            //  devrait ete fait au niveau de voxco.agent.webservice mais malheureusement ce n'est
            //  pas le cas. Si changement il y a effectuer une recherche sur TODO:voxco.agent.webservice
            //
            // TODO:voxco.agent.webservice; standartisation des reponse -> cmd//status; name:value ; name:value 
            //

            arguments[2] = PAUSERequest.m_szName + "//" + arguments[2]

            PAUSERequest.debug("PAUSERequest.onResponse> The agent is now on pause -- response: " + arguments[2]);

            //
            //  Creation de l'objet parser... un nouveau a chaque requete.
            //
            PAUSERequest.m_Parser = new ResponseParser(PAUSERequest.m_szName, arguments[2], PAUSERequest.error, null, PAUSERequest.onParse);
            PAUSERequest.m_Parser.parse(";");

            try {
                if (PAUSERequest.m_Callback.onSuccess != null)
                    PAUSERequest.m_Callback.onSuccess(PAUSERequest.m_Parser);
            }
            catch (e) {
                var message =  PAUSERequest.m_szName + " command caught an exception -- error: " + e.message;
                setTimeout(function () { PAUSERequest.onError(message); }, 1);
            }


      
            return;
        },

        keepPreviousState: function (state) {
            this.m_szPreviousState = state;
        },

        getPreviousState: function () {
            return this.m_szPreviousState;
        },

        executeOnNetworkError: function (error, httpstatus) {

            //
            //  TODO Si necessaire mettre en place un mecanique de reassaie si nous avons des erreurs de transmission
            //  reseau ( command PAUSE ) . Voir ICRequest comme exemple
            //        

            PAUSERequest.m_szErrorType = CommandErrorType.network;
            if (httpstatus == 911)
                PAUSERequest.m_szErrorType = CommandErrorType.javascriptexecption;


            CallStats.addNetworkError();
            PAUSERequest.m_iNbError++;
            PAUSERequest.onError(error);
        },

        onError: function (error) {

            if (typeof error == "string")
                PAUSERequest.m_szErrorMsg = error;

            ConsoleDebug._error(error);

            if (PAUSERequest.m_Callback.onNetworkError != null) {
                PAUSERequest.m_Callback.onNetworkError(PAUSERequest.m_szName, error);
                return;
            }
        },

        warning: function (message) {

            if (typeof PAUSERequest.m_Callback.onLog == "function")
                PAUSERequest.m_Callback.onLog(LogLevel.warning, message);

            ConsoleDebug._warning(message);
        },

        debug: function (message) {

            if (typeof PAUSERequest.m_Callback.onLog == "function")
                PAUSERequest.m_Callback.onLog(LogLevel.debug, message);

            ConsoleDebug._debug(message);
        },

        error: function (szMessage) {

            PAUSERequest.m_szErrorMsg = szMessage;
            if (typeof PAUSERequest.m_Callback.onLog != "function")
                return;

            PAUSERequest.m_Callback.onLog(LogLevel.error, szMessage);
            return;
        },

        getError: function () {
            return this.m_szErrorMsg;
        },

  
        getElapseTime: function () {

            if (this.m_StartTime == null)
                return 0;

            var elapseTime = new Date().getTime() - this.m_StartTime.getTime();
            this.m_StartTime = null;

            return elapseTime;
        },

        reset: function () {
            this.m_szErrorMsg = "";
            this.m_iNbError = 0;
        }
    }



    var DIALRequest = {

        m_iNbError: 0,

        m_ManualDialing : null ,
        m_Url: this.location.protocol + "//" + this.location.hostname + "/Voxco.Agent.WebService/PHService.asmx",
        m_Method: "post",
        m_StartTime: null,
        m_szName        : "dial",
        m_szErrorMsg    : "",
        m_szPreviousState: "",
        m_szDialNumber: "" ,
        m_szSOAPMethod: "ExecProntoCommand",
        m_szErrorType: CommandErrorType.success,
        m_Parser        : null,
        m_bInprogress   : false,
        m_UserId        : 0,
        m_szRequestParameter: "" ,
        m_szSessionId   : "",
        m_DialCompletionCallBack: null ,
        m_Callback: { onDisplayAlert: null, onLog: null, onSuccess: null, onExecute: null, onNetworkError: null },


        init: function (callback) {

            if (typeof callback != "object")
                return;

            //
            //  onExecute       ->    appeler avant l'envoie de la requette
            //  onLog           ->    pour les traces 
            //  onSuccess       ->    Appeler lorsque nous avons recus la reponses du serveur
            //  onNetworkError  ->    appeler lorsque nous avons des problemes reseaux ou http
            //

            if (typeof callback.onDisplayAlert == "function")
                this.m_Callback.onDisplayAlert = callback.onDisplayAlert;

            if (typeof callback.onExecute == "function")
                this.m_Callback.onExecute = callback.onExecute;

            if (typeof callback.onLog == "function")
                this.m_Callback.onLog = callback.onLog;

            if (typeof callback.onSuccess == "function")
                this.m_Callback.onSuccess = callback.onSuccess;

            if (typeof callback.onNetworkError == "function")
                this.m_Callback.onNetworkError = callback.onNetworkError;
        },

        execute: function (userid) {

            if (this.m_bInprogress == true) {

                this.debug( "DIALRequest.execute> There is already a dial request pending ..." ) ;
                return;
            }


            DialogBox.enableShowAlert(true);

            this.reset();


            //
            //  CallClass.isInCall()    -> agent deja en appel 
            //  CallClass.isRespondant() -> l'agent est toujours dans la fiche. Pas le droit de faire 
            //                             un dial apres avoir eu le repondant en ligne au moins une fois. Si le questionnaire
            //                             est mal programme , un dial est envoye a l'insu de l'agent apres 
            //                             avoir recu l'evenement disconnect ou apres l'excution du mask hangup .
            //                      
            //                             Plusieurs dials sont permis si et seulement si le numero de telephone appele
            //                             est different de celui du repondant

            var bInCall = CallClass.isInCall();
            if (bInCall == true ) {
                this.error("DIALRequest.execute> The agent is already in call ... dial execution is refused... incall: " + bInCall);
                return;
            }

            var bIsRespondantNumber = CallClass.isRespondent(this.m_szDialNumber);
            if (bIsRespondantNumber == true)
                this.error("DIALRequest.execute>  The respondant has been call twiced in the interview -- Call id:  " + CallClass.Get( "CALLID", "No Call Id" ) + " -- Calling Number: " + CallClass.Get("CALLINGNUMBER", "no calliing number") );



            this.m_UserId       = userid;
            this.m_StartTime    = new Date();
            this.m_bInprogress  = true;

            //
            // l'agent n'est plus en pause ...
            //  
            //
            PAUSERequest.stopChronometer();

            //
            //  OnExecute sert a initialiser les variables appartentant a voxco.agent avant l'envoie de la requete
            //

            if (typeof this.m_Callback.onExecute == "function")
                this.m_Callback.onExecute();

            this.debug("DIALRequest.execute> Sending " + this.m_szName + " request to web service... Parameters: " + this.m_szRequestParameter);

            var webservice = new SOAPWebServiceCall(this.m_szName, this.m_Url, this.m_szSOAPMethod, this.error, this.debug);
            webservice.setParams(new Array('_userId', this.m_UserId, '_command', this.m_szName, '_pairParams', this.m_szRequestParameter));
            webservice.execute(this.onResponse);
        },


        NotifyDialCompletion: function( bSuccess )
        {
            if (typeof this.m_DialCompletionCallBack != "function")
                return;
           
            //
            //  Executer qu'une seule fois 
            //
            this.m_DialCompletionCallBack(bSuccess);
            this.m_DialCompletionCallBack = null;
            return;
        },

        setDialCompletionCallBack: function( callback )        {

            if (typeof callback != "function")
                return;

            this.m_DialCompletionCallBack = callback;
            return;
        },

        name: function () {
            return this.m_szName;
        },

        isDialInprogress: function () {
            return this.m_bInprogress;
        },

        isErrorSet: function (error) {

            var bSet = false;
            var value = CallClass.Get("ERR");
            if (value == error)
                bSet = true;

            return bSet;
        },

        onResponse: function (bRequestSuccess, webservice, error, httpstatus) {

         
            if (bRequestSuccess == false) {
                webservice = null;
                setTimeout(function () { DIALRequest.executeOnNetworkError(error, httpstatus); }, 50);
                return;
            }

            DIALRequest.debug("DIALRequest.onResponse> Dial request just came back response: " + arguments[2]);
            CallClass.Parse(DIALRequest.m_szName, ";", arguments[2], DIALRequest.error);

            //
            //  Creation de l'objet parser... un nouveau a chaque requete.
            //
            try {

                if (DIALRequest.m_Callback.onSuccess != null) {
                    var bSuccess = DIALRequest.m_Callback.onSuccess(CallClass.getParser());
                    CallStats.callStart();
                    DIALRequest.NotifyDialCompletion(bSuccess);
                    GETMessage.setIncallTimeout();
                }
                    
            }
            catch (e) {
                var message = DIALRequest.m_szName + " command caught an exception -- error: " + e.message;
                setTimeout(function () { DIALRequest.onError(message); }, 1);
            }

            DIALRequest.m_bInprogress = false;
            return;
        },

        setDialNumber: function (szDialNumber) {
            if( typeof szDialNumber == "string" )
                this.m_szDialNumber = szDialNumber;
        },

        setRequestParameter: function (szParameter) {
            this.m_szRequestParameter = szParameter ;
        },

        keepPreviousState: function (state) {
            this.m_szPreviousState = state;
        },

        getPreviousState: function () {
            return this.m_szPreviousState;
        },

        executeOnNetworkError: function (error, httpstatus) {

            //
            //  TODO Si necessaire mettre en place un mecanique de reassaie si nous avons des erreurs de transmission
            //  reseau ( command DIAL ) . Voir ICRequest comme exemple
            //        

           
            DIALRequest.m_szErrorType = CommandErrorType.network;
            if (httpstatus == 911)
                DIALRequest.m_szErrorType = CommandErrorType.javascriptexecption;

            CallStats.addNetworkError();
            DIALRequest.m_iNbError++;
            DIALRequest.onError(error);
        },

        onError: function (error) {

            if (typeof error == "string")
                DIALRequest.m_szErrorMsg = error;

            ConsoleDebug._error(error);

            if (DIALRequest.m_Callback.onNetworkError != null) {
                DIALRequest.m_Callback.onNetworkError(DIALRequest.m_szName, error);
                return;
            }
        },

        debug: function (message) {

            if (typeof DIALRequest.m_Callback.onLog == "function")
                DIALRequest.m_Callback.onLog(LogLevel.debug, message);

            ConsoleDebug._debug(message);
            return;
        },

        error: function (szMessage) {

            this.m_szErrorMsg = szMessage;
            if (typeof DIALRequest.m_Callback.onLog != "function")
                return;

            DIALRequest.m_Callback.onLog(LogLevel.error, szMessage);
            return;
        },

        getError: function () {
            return this.m_szErrorMsg;
        },

  
        getElapseTime: function () {

            if (this.m_StartTime == null)
                return 0;

            var elapseTime = new Date().getTime() - this.m_StartTime.getTime();
            this.m_StartTime = null;

            return elapseTime;
        },

        reset: function () {
            this.m_szErrorMsg = "";
            this.m_iNbError = 0;
        }
    }



    var HANGUPRequest = {

        m_iNbError: 0,

        m_ManualDialing: null,
        m_Url: this.location.protocol + "//" + this.location.hostname + "/Voxco.Agent.WebService/PHService.asmx",
        m_Method: "post",
        m_StartTime: null,
        m_szName: "hangup",
        m_szErrorMsg: "",
        m_szPreviousState: "" ,
        m_szSOAPMethod: "ExecProntoCommand",
        m_szErrorType: CommandErrorType.success,
        m_Parser: null,
        m_bInprogress: false,
        m_UserId: 0,
        m_szRequestParameter: "",
        m_szSessionId: "",
        m_Callback: { onDisplayAlert: null, onLog: null, onSuccess: null, onExecute: null, onNetworkError: null },


        init: function (callback) {

            if (typeof callback != "object")
                return;

            //
            //  onExecute       ->    appeler avant l'envoie de la requette
            //  onLog           ->    pour les traces 
            //  onSuccess       ->    Appeler lorsque nous avons recus la reponses du serveur
            //  onNetworkError  ->    appeler lorsque nous avons des problemes reseaux ou http
            //

            if (typeof callback.onDisplayAlert == "function")
                this.m_Callback.onDisplayAlert = callback.onDisplayAlert;

            if (typeof callback.onExecute == "function")
                this.m_Callback.onExecute = callback.onExecute;

            if (typeof callback.onLog == "function")
                this.m_Callback.onLog = callback.onLog;

            if (typeof callback.onSuccess == "function")
                this.m_Callback.onSuccess = callback.onSuccess;

            if (typeof callback.onNetworkError == "function")
                this.m_Callback.onNetworkError = callback.onNetworkError;
        },

      
        execute: function (userid, line , bButton ) {

            if (this.m_bInprogress == true) {

                this.debug("HANGUPRequest.execute> There is already a dial request pending ...");
                return;
            }

            this.reset();
            this.m_UserId = userid;
            this.m_StartTime = new Date();
            this.m_bInprogress = true;

            //
            //  OnExecute sert a initialiser les variables appartentant a voxco.agent avant l'envoie de la requete
            //

            if (typeof this.m_Callback.onExecute == "function")
                this.m_Callback.onExecute();

            this.debug("HANGUPRequest.execute> Sending " + this.m_szName + " request to web service... Parameters: " + this.m_szRequestParameter);

            var webservice = null;
            if (bButton == true) {
                webservice = new SOAPWebServiceCall(this.m_szName, this.m_Url, "AgentHangup", this.error, this.debug);
                webservice.setParams(new Array('_userId', this.m_UserId, '_lineno', line));
            }
            else {
                webservice = new SOAPWebServiceCall(this.m_szName, this.m_Url, this.m_szSOAPMethod, this.error, this.debug);
                webservice.setParams(new Array('_userId', this.m_UserId, '_command', this.m_szName, '_pairParams', this.m_szRequestParameter));
            }

            webservice.execute(this.onResponse);
            return;
        },

        name: function () {
            return this.m_szName;
        },

        isErrorSet: function (error) {

            var bSet = false;
            var value = CallClass.Get("ERR");
            if (value == error)
                bSet = true;

            return bSet;
        },


        onResponse: function (bRequestSuccess, webservice, error, httpstatus) {

            HANGUPRequest.m_bInprogress = false;

            if (bRequestSuccess == false) {
                webservice = null;
                setTimeout(function () { HANGUPRequest.executeOnNetworkError(error, httpstatus); }, 50);
                return;
            }

           
            CallClass.callDropped(CallClass.Get("LINE"));

            HANGUPRequest.debug("HANGUPRequest.onResponse> Hangup request just came back response: " + arguments[2]);
            HANGUPRequest.m_Parser = new ResponseParser(HANGUPRequest.m_szName, arguments[2], HANGUPRequest.error);
            HANGUPRequest.m_Parser.parse();

            //
            //  Si le hangup est un succes , nous accelerons la frequence du GETMessage pour la reception de l'evenement 
            //  disconnect
            //
            if (HANGUPRequest.m_Parser.isStatus("OK") == true) {
                HANGUPRequest.debug("HANGUPRequest.onResponse> The agent is not on call anymore. The call has been dropped by the agent.")
            }
           

            //
            //  Creation de l'objet parser... un nouveau a chaque requete.
            //
            try {
                if (HANGUPRequest.m_Callback.onSuccess != null)
                    HANGUPRequest.m_Callback.onSuccess(HANGUPRequest.m_Parser);
            }
            catch (e) {
                var message = HANGUPRequest.m_szName + " command caught an exception -- error: " + e.message;
                setTimeout(function () { HANGUPRequest.onError(message); }, 1);
            }


            return;
        },


        setRequestParameter: function (szParameter) {
            this.m_szRequestParameter = szParameter;
        },

        keepPreviousState: function (state) {
            this.m_szPreviousState = state;
        },

        getPreviousState: function () {
            return this.m_szPreviousState;
        },

        executeOnNetworkError: function (error, httpstatus) {

            //
            //  TODO Si necessaire mettre en place un mecanique de reassaie si nous avons des erreurs de transmission
            //  reseau ( command DIAL ) . Voir ICRequest comme exemple
            //        

            HANGUPRequest.m_szErrorType = CommandErrorType.network;
            if (httpstatus == 911)
                HANGUPRequest.m_szErrorType = CommandErrorType.javascriptexecption;

            CallStats.addNetworkError();
            HANGUPRequest.m_iNbError++;
            HANGUPRequest.onError(error);
        },

        onError: function (error) {

            if (typeof error == "string")
                HANGUPRequest.m_szErrorMsg = error;

            ConsoleDebug._error(error);

            CallStats.addNetworkError();

            if (HANGUPRequest.m_Callback.onNetworkError != null) {
                HANGUPRequest.m_Callback.onNetworkError(HANGUPRequest.m_szName, error);
                return;
            }
        },

        debug: function (message) {

            if (typeof HANGUPRequest.m_Callback.onLog == "function")
                HANGUPRequest.m_Callback.onLog(LogLevel.debug, message);

            ConsoleDebug._debug(message);
            return;
        },

        error: function (szMessage) {

            HANGUPRequest.m_szErrorMsg = szMessage;
            if (typeof HANGUPRequest.m_Callback.onLog != "function")
                return;

            ConsoleDebug._error(szMessage);
            HANGUPRequest.m_Callback.onLog(LogLevel.error, szMessage);
            return;
        },

        getError: function () {
            return this.m_szErrorMsg;
        },


        getElapseTime: function () {

            if (this.m_StartTime == null)
                return 0;

            var elapseTime = new Date().getTime() - this.m_StartTime.getTime();
            this.m_StartTime = null;

            return elapseTime;
        },

        reset: function () {
            this.m_szErrorMsg = "";
            this.m_iNbError = 0;
        }
    }

//  MUTERequest
//
//  Cette objet permet de controler le MUTE/UNMUTE pour retirer un supeviseur de la conference si conference il y a 
//  
//
    var MUTERequest = {

        //
        //  m_iNbError -> compte le nombre d'erreurs sur l'envoie de la requete 
        //  m_szUnMute -> Constante qui definit le nom de la commande UnMute
        //  m_szMute   -> Constante qui definit le nom de la commande Mute
        //  
        //  m_Url -> Definit la destination de la commande
        //  m_Method -> Definit l'utilisation du verbe http ( get | post )
        //
        //  m_szName -> Nom de la commande UnMute / Mute
        //  m_szState -> L'etat de l'object Mute / UnMute 
        //
        //  m_szSOAPMethod -> Methode SOAP
        //  m_szErrorType -> Type d'erreurs ( Java script ,  Network )
        //
        //  m_Parser -> Le parser de la reponse 
        //  m_bInprogress -> est ce que la requete est inprogress ( true | false )
        //  m_UserId    -> le User id 
        //
        //  m_Callback -> definit les callback
        //      
        //      onDisplayAlert -> Les alertes
        //      onLog -> Les logs    
        //      onSuccess -> execute lorsque nous recevons la reponse
        //      onExecute -> execute avant l'envoie de la requete
        //      onNetworkError -> appeler lorsque nous avons une erreur reseau ou http
        //

        m_iNbError: 0,
        m_szUnMute: "unmute" ,
        m_szMute : "mute" ,
        m_Url: this.location.protocol + "//" + this.location.hostname + "/Voxco.Agent.WebService/PHService.asmx",
        m_Method: "post",
        m_StartTime: null,
        m_szName: "",
        m_szState : "",
        m_szErrorMsg: "",
        m_szPreviousState: "",
        m_szSOAPMethod: "ExecProntoCommand",
        m_szErrorType: CommandErrorType.success,
        m_Parser: null,
        m_bInprogress: false,
        m_UserId: 0,
        m_szSessionId: "",
        m_Callback: { onDisplayAlert: null, onLog: null, onSuccess: null, onExecute: null, onNetworkError: null },


        init: function (callback) {

            if (typeof callback != "object")
                return;

            //
            //  onExecute       ->    appeler avant l'envoie de la requette
            //  onLog           ->    pour les traces 
            //  onSuccess       ->    Appeler lorsque nous avons recus la reponses du serveur
            //  onNetworkError  ->    appeler lorsque nous avons des problemes reseaux ou http
            //

            if (typeof callback.onDisplayAlert == "function")
                this.m_Callback.onDisplayAlert = callback.onDisplayAlert;

            if (typeof callback.onExecute == "function")
                this.m_Callback.onExecute = callback.onExecute;

            if (typeof callback.onLog == "function")
                this.m_Callback.onLog = callback.onLog;

            if (typeof callback.onSuccess == "function")
                this.m_Callback.onSuccess = callback.onSuccess;

            if (typeof callback.onNetworkError == "function")
                this.m_Callback.onNetworkError = callback.onNetworkError;
        },


        
        //
        //  MUTERequest.execute
        //
        //  Envoie de la requete mute ou unmute
        //
        //

        execute: function (action , userid) {
            
           
            if (this.m_bInprogress == true) {

                this.debug("MUTERequest.execute> There is already a mute or unmute request pending ...");
                return;
            }
           
            this.m_szName = action;

            //
            //  Est ce que l'etat a change ... Plusieurs mute consecutifs ou Plusieurs unmute consecutifs ne sont pas envoyes
            //
            if (this.m_szName == this.m_szState)
            {
                this.debug("MUTERequest.execute> State as not change ... No need to mute or unmute.");
                return;
            }

            if (this.m_szName == this.m_szUnMute && this.m_szState != this.m_szMute)
            {
                this.debug("MUTERequest.execute> No need to unmute , Not in mute state...");
                return;
            }

            this.reset();
            this.m_UserId = userid;
            this.m_StartTime = new Date();
            this.m_bInprogress = true;

            //
            //  OnExecute sert a initialiser les variables appartentant a voxco.agent avant l'envoie de la requete
            //

            if (typeof this.m_Callback.onExecute == "function")
                this.m_Callback.onExecute(this.m_szName);

            this.debug("MUTERequest.execute> Sending " + this.m_szName + " request to web service... Parameters: " + this.m_szRequestParameter);

            this.m_szState = this.m_szName;
            var webservice = null;
            webservice = new SOAPWebServiceCall(this.m_szName, this.m_Url, "ExecProntoCommand", this.error, this.debug);
            webservice.setParams(new Array('_userId', this.m_UserId, '_command', this.m_szName, '_pairParams', ''));
            webservice.execute(this.onResponse);
            return;
        },

      
        //
        //  MUTERequest.Set
        //
        //  Mise a jour de l'action a envoye
        //
        Set: function (action) {
            if (this.m_szName != action )
                this.m_szName = action; 
        },


        name: function () {
            return this.m_szName;
        },

        //
        // MUTERequest.onResponse
        //
        //  Reception de la reponse.
        //
        //      bRequestSuccess  ->  false echec , true success
        //      webservice       ->  objet de la requete SOAP
        //      error            ->  contient le message d'erreur en cas d'echec de l'envoie
        //      httpstatus       ->  Le status HTTP ( 4XX , 5XX )
        //
        onResponse: function (bRequestSuccess, webservice, error, httpstatus) {

            MUTERequest.m_bInprogress = false;

            if (bRequestSuccess == false) {
                webservice = null;
                setTimeout(function () { MUTERequest.executeOnNetworkError(error, httpstatus); }, 50);
                return;
            }

            //
            //  Creation du parser pour la reponse
            //
            MUTERequest.debug("MUTERequest.onResponse>" + MUTERequest.m_szName +  " request just came back response: " + arguments[2]);
            MUTERequest.m_Parser = new ResponseParser(MUTERequest.m_szName, arguments[2], MUTERequest.error);
            MUTERequest.m_Parser.parse();

           
            if (MUTERequest.m_Parser.isStatus("OK") == true) {
                MUTERequest.debug("MUTERequest.onResponse> The supervisor is on " + MUTERequest.m_szName + " now...");
            }


          
            try {
                if (MUTERequest.m_Callback.onSuccess != null)
                    MUTERequest.m_Callback.onSuccess(MUTERequest.m_Parser);
            }
            catch (e) {
                //
                //  Error java script sur le traitement du onSucess 
                //
                var message = MUTERequest.m_szName + " command caught an exception -- error: " + e.message;
                setTimeout(function () { MUTERequest.onError(message); }, 1);
            }

            return;
        },

        executeOnNetworkError: function (error, httpstatus) {

            //
            //  TODO Si necessaire mettre en place un mecanique de reassaie si nous avons des erreurs de transmission
            //  reseau ( command DIAL ) . Voir ICRequest comme exemple
            //        

           

            MUTERequest.m_szErrorType = CommandErrorType.network;
            if (httpstatus == 911)
                MUTERequest.m_szErrorType = CommandErrorType.javascriptexecption;

            CallStats.addNetworkError();
            MUTERequest.m_iNbError++;
            MUTERequest.onError(error);
        },

        onError: function (error) {

            if (typeof error == "string")
                MUTERequest.m_szErrorMsg = error;

            ConsoleDebug._error(error);

            CallStats.addNetworkError();

            if (MUTERequest.m_Callback.onNetworkError != null) {
                MUTERequest.m_Callback.onNetworkError(MUTERequest.m_szName, error);
                return;
            }
        },

        debug: function (message) {

            if (typeof MUTERequest.m_Callback.onLog == "function")
                MUTERequest.m_Callback.onLog(LogLevel.debug, message);

            ConsoleDebug._debug(message);
            return;
        },

        error: function (szMessage) {

            MUTERequest.m_szErrorMsg = szMessage;
            if (typeof MUTERequest.m_Callback.onLog != "function")
                return;

            ConsoleDebug._error(szMessage);
            MUTERequest.m_Callback.onLog(LogLevel.error, szMessage);
            return;
        },

        getError: function () {
            return this.m_szErrorMsg;
        },


        getElapseTime: function () {

            if (this.m_StartTime == null)
                return 0;

            var elapseTime = new Date().getTime() - this.m_StartTime.getTime();
            this.m_StartTime = null;

            return elapseTime;
        },

        resetState: function () {
            this.m_szName = "";
            this.m_szState = "";
        },

        reset: function () {
            this.m_szErrorMsg = "";
            this.m_iNbError = 0;
        }
    }

    var MEDIARequest = {

        m_iNbError: 0,
        m_iNbMediaBusyRetry: 0 ,
        m_Url: this.location.protocol + "//" + this.location.hostname + "/Voxco.Agent.WebService/PHService.asmx",
        m_Method: "post",
        m_iTimerId: 0 ,
        m_StartTime: null,
        m_szName: "",
        m_szErrorMsg: "",
        m_szSOAPMethod: "ExecProntoCommand",
        m_szErrorType: CommandErrorType.success,
        m_Parser: null,
        m_bInprogress: false,
        m_bStopByCommand: false ,
        m_UserId: 0,
        m_szRequestParameter: "",
        m_Callback: { onDisplayAlert: null, onLog: null, onSuccess: null, onExecute: null, onNetworkError: null },

        init: function (callback) {

            if (typeof callback != "object")
                return;

            //
            //  onExecute       ->    appeler avant l'envoie de la requette
            //  onLog           ->    pour les traces 
            //  onSuccess       ->    Appeler lorsque nous avons recus la reponses du serveur
            //  onNetworkError  ->    appeler lorsque nous avons des problemes reseaux ou http
            //

            if (typeof callback.onDisplayAlert == "function")
                this.m_Callback.onDisplayAlert = callback.onDisplayAlert;

            if (typeof callback.onExecute == "function")
                this.m_Callback.onExecute = callback.onExecute;

            if (typeof callback.onLog == "function")
                this.m_Callback.onLog = callback.onLog;

            if (typeof callback.onSuccess == "function")
                this.m_Callback.onSuccess = callback.onSuccess;

            if (typeof callback.onNetworkError == "function")
                this.m_Callback.onNetworkError = callback.onNetworkError;
        },


   
        execute: function (userid, mediaCommand ) {

            if (MEDIARequest.m_bInprogress == true) {

                MEDIARequest.warning("MEDIARequest.execute> There is already a media request (" + MEDIARequest.m_szName + ") " + "in progress ...");

                if( MEDIARequest.m_iNbMediaBusyRetry < 5 ){
                    MEDIARequest.m_iTimerId = setTimeout( function(){ MEDIARequest.execute( userid, mediaCommand) ; } , 200 ) ;
                    MEDIARequest.m_iNbMediaBusyRetry++ ;
                    return ;
                }

                MEDIARequest.m_iNbMediaBusyRetry = 0;
                MEDIARequest.error(  MEDIARequest.m_szName +  ": the media device is busy. We will send the command just in case .... ") ;
            }


            this.reset();
            this.m_UserId = userid;
            this.m_StartTime = new Date();
            this.m_bInprogress = true;
            this.m_szName = mediaCommand ;
            //
            //  OnExecute sert a initialiser les variables appartentant a voxco.agent avant l'envoie de la requete
            //

            if (typeof this.m_Callback.onExecute == "function")
                this.m_Callback.onExecute();

            this.debug("MEDIARequest.execute> Sending " + this.m_szName + " request to web service... Parameters: " + this.m_szRequestParameter);

            var webservice = new SOAPWebServiceCall(this.m_szName, this.m_Url, this.m_szSOAPMethod, this.error, this.debug);
            webservice.setParams(new Array('_userId', this.m_UserId, '_command', this.m_szName, '_pairParams', this.m_szRequestParameter));
            webservice.execute(this.onResponse);
            return;
        },

        name: function () {
            return this.m_szName;
        },

        isStopByCommand: function(){
            var bStopByCommand = this.m_bStopByCommand;
            this.m_bStopByCommand = false;
            return bStopByCommand;
        },

        manualStop: function(){
            this.m_bStopByCommand = true;
        },

        //
        //  MEDIARequest.stop
        //
        //
        stop: function (bClearTimer) {

            //
            //  Nous regardons si la command a ete arrete par le mask STOP.
            //  Si ce n'est pas le cas , nous avons recu l'evenement evt-stop-record ou evt-stop-play
            //  de pronto indaquant que l'activite est termine
            //
            //  donc m_bInprogress = false 
            //
            var bStopByCommand = this.isStopByCommand();
            if (bStopByCommand == false)
                this.m_bInprogress = false;

            try {
                if (typeof bClearTimer == "boolean" && this.m_iTimerId != 0) {
                    clearTimeout(this.m_iTimerId);
                    this.m_iTimerId = 0;
                }
            }
            catch (e) {
                ConsoleDebug._error("MEDIARequest.stop> caught a java script exception -- error: " + e.message);
            }


            //
            //  Lorsque mous arretons un action record ou play nous recevons les evenements:
            //
            //  1) evt-stop-playing 
            //  ou
            //  2) evt-stop-recording
            //
            //  Cette evenement peut prend jusqu'a deux secondes avant de la rececvoir. Si entre temps
            //  nous avons demarre un play ou un record , nous devons le laisser a l'ecran
            //
            //  true -> retrait de l'icone qui indique l'action recording ou playing
            //  false -> Nous le laissons a l'ecran
            //
            return bStopByCommand == true ? false : true;
        },

        isInProgress: function(){
            return this.m_bInprogress ;
        },

        isErrorSet: function (error) {

            var bSet = false;
            var value = CallClass.Get("ERR");
            if (value == error)
                bSet = true;

            return bSet;
        },


        //
        //  Ajout des parametres esssentiels pour le systeme d'enregistrements vocaux 
        //  
        //  RECNUMB  -> le record de base de donnees
        //  createid ->  1|0 permet de signifier si le service d'enregistrement est disponible ou pas .La reference est le MASK record
        //  maxtrix  -> la matrice du questionnaire 
        //  callid   -> Le nombre de fois que le repondant a ete appele 
        //  question -> Le libelle de la question
        //
        addParameters: function (action, cmdParameters, hiddenParameters ) {

            //
            //  Si l'action n'est pas un enregistrement , aucun parametres n'est ajoute . Cet objet est 
            //  utilise a la fois pour le record , play , senddtmf
            //

            if (typeof action != "string" || action != "RECORD")
                return cmdParameters;

            if (typeof cmdParameters != "string")
                return cmdParameters;

            if (typeof hiddenParameters != "object")
                return cmdParameters;
           

            //var createid = hiddenParameters.getItem('createid', "0");
            var callcount = hiddenParameters.getItem('CALLID', "");
            var question = hiddenParameters.getItem('QLABEL', "");
            var caseid   = hiddenParameters.getItem('RECNUMB', "");
            var matrix = hiddenParameters.getItem('MATRIXINDEX', "");

            //cmdParameters += ",NAME='createid'" + ",VALUE='" + createid + "'";
            cmdParameters += ",NAME='callcount'" + ",VALUE='" + callcount + "'";
            cmdParameters += ",NAME='question'" + ",VALUE='" + question + "'";
            cmdParameters += ",NAME='matrix'" + ",VALUE='" + matrix + "'";
            cmdParameters += ",NAME='caseid'" + ",VALUE='" + caseid + "'";

            return cmdParameters;       
        },

        onStopResponse: function(bRequestSuccess, webservice, error, httpstatus) {

            return;
        },

        onResponse: function (bRequestSuccess, webservice, error, httpstatus) {


            //
            //  Contrairement au autre objet , le media demeure inprogress tant
            //  et aussi longtemps que nous n'avons pas recu l'evenement du serveur
            //  qui nous indique que l'activite audio n'est termine ou que la command STOP n'a pas
            //  ete emise.
            //
            //
            if (bRequestSuccess == false) {
                webservice = null;
                setTimeout(function () { MEDIARequest.executeOnNetworkError(error, httpstatus); }, 50);
                return;
            }


            //
            //  Creation de l'objet parser... un nouveau a chaque requete.
            //
            MEDIARequest.debug("MEDIARequest.onResponse> Media request just came back response: " + arguments[2]);

            MEDIARequest.m_Parser = new ResponseParser(MEDIARequest.m_szName, arguments[2], MEDIARequest.error);
            MEDIARequest.m_Parser.parse();

            switch (MEDIARequest.m_Parser.getStatus()) {
                case "OK":
                    MEDIARequest.debug("MEDIARequest.onResponse> The " + MEDIARequest.m_szName + "is started...")
                    break;
                case "ERR":
                default:
                    MEDIARequest.debug("MEDIARequest.onResponse> " + MEDIARequest.m_szName + " failed with " + MEDIARequest.m_Parser.getStatus());
                    MEDIARequest.m_bInprogress = false;
                    break;
            }

            try {
                if (MEDIARequest.m_Callback.onSuccess != null)
                    MEDIARequest.m_Callback.onSuccess(MEDIARequest.m_Parser);
            }
            catch (e) {
                var message = MEDIARequest.m_szName + " command caught an exception -- error: " + e.message;
                setTimeout(function () { MEDIARequest.onError(message); }, 1);
            }

            return;
        },


        setRequestParameter: function (szParameter) {
            this.m_szRequestParameter = szParameter;
        },

  
        executeOnNetworkError: function (error, httpstatus) {

            if (MEDIARequest.m_iNbError > 3 || httpstatus == 911) {

                MEDIARequest.m_szErrorType = CommandErrorType.network;
                if (httpstatus == 911)
                    MEDIARequest.m_szErrorType = CommandErrorType.javascriptexecption;

                MEDIARequest.onError(error);
                MEDIARequest.reset();
                return;
            }

            CallStats.addNetworkError();
            MEDIARequest.m_iNbError++;

            var webservice = new SOAPWebServiceCall(MEDIARequest.m_szName, MEDIARequest.m_Url, MEDIARequest.m_szSOAPMethod, MEDIARequest.error, MEDIARequest.debug);
            webservice.setParams(new Array('_userId', MEDIARequest.m_UserId, '_command', MEDIARequest.m_szName, '_pairParams', MEDIARequest.m_szRequestParameter));
            webservice.execute(this.onResponse);
        },

        onError: function (error) {

            if (typeof error == "string")
                MEDIARequest.m_szErrorMsg = error;

            ConsoleDebug._error(error);

            if (MEDIARequest.m_Callback.onNetworkError != null) {
                MEDIARequest.m_Callback.onNetworkError(this.m_szName, error);
                return;
            }
        },

        debug: function (message) {

            if (typeof MEDIARequest.m_Callback.onLog == "function")
                MEDIARequest.m_Callback.onLog(LogLevel.debug, message);

            ConsoleDebug._debug(message);
        },

        error: function (szMessage) {

            MEDIARequest.m_szErrorMsg = szMessage;
            if (typeof MEDIARequest.m_Callback.onLog != "function")
                return;

            ConsoleDebug._error(szMessage);
            MEDIARequest.m_Callback.onLog(LogLevel.error, szMessage);
            return;
        },

        warning: function (szMessage) {

            MEDIARequest.m_szErrorMsg = szMessage;
            if (typeof MEDIARequest.m_Callback.onLog != "function")
                return;

            ConsoleDebug._warning(szMessage);
            MEDIARequest.m_Callback.onLog(LogLevel.warning, szMessage);
            return;
        },

        getError: function () {
            return this.m_szErrorMsg;
        },


        getElapseTime: function () {

            if (this.m_StartTime == null)
                return 0;

            var elapseTime = new Date().getTime() - this.m_StartTime.getTime();
            this.m_StartTime = null;

            return elapseTime;
        },

        reset: function () {
            this.m_szErrorMsg = "";
            this.m_iNbError = 0;
            this.m_bInprogress = false;
        }
    }

    var STOPMediaRequest = {

        m_iNbError: 0,
        m_Url: this.location.protocol + "//" + this.location.hostname + "/Voxco.Agent.WebService/PHService.asmx",
        m_Method: "post",
        m_iTimerId: 0,
        m_StartTime: null,
        m_szName: "STOP",
        m_szErrorMsg: "",
        m_szSOAPMethod: "ExecProntoCommand",
        m_szErrorType: CommandErrorType.success,
        m_Parser: null,
        m_bInprogress: false,
        m_Parameter: null,
        m_UserId: 0,
        m_Callback: { onDisplayAlert: null, onLog: null, onSuccess: null, onExecute: null, onNetworkError: null },

        init: function (callback) {

            if (typeof callback != "object")
                return;

            //
            //  onExecute       ->    appeler avant l'envoie de la requette
            //  onLog           ->    pour les traces 
            //  onSuccess       ->    Appeler lorsque nous avons recus la reponses du serveur
            //  onNetworkError  ->    appeler lorsque nous avons des problemes reseaux ou http
            //

            if (typeof callback.onDisplayAlert == "function")
                this.m_Callback.onDisplayAlert = callback.onDisplayAlert;

            if (typeof callback.onExecute == "function")
                this.m_Callback.onExecute = callback.onExecute;

            if (typeof callback.onLog == "function")
                this.m_Callback.onLog = callback.onLog;

            if (typeof callback.onSuccess == "function")
                this.m_Callback.onSuccess = callback.onSuccess;

            if (typeof callback.onNetworkError == "function")
                this.m_Callback.onNetworkError = callback.onNetworkError;
        },



        execute: function (parameter , userid) {

            if (STOPMediaRequest.m_bInprogress == true) {
                return;
            }

            if (MEDIARequest.isInProgress() == false) {
                this.debug("STOPMediaRequest.execute> Nothing to stop!  Command will be sent to dialer just in case.", true);
            }


            MEDIARequest.manualStop();

            this.reset();
            this.m_UserId = userid;
            this.m_Parameter = parameter;
            this.m_StartTime = new Date();
            this.m_bInprogress = true;

            //
            //  OnExecute sert a initialiser les variables appartentant a voxco.agent avant l'envoie de la requete
            //

            if (typeof this.m_Callback.onExecute == "function")
                this.m_Callback.onExecute();

            this.debug("STOPMediaRequest.execute> Sending " + this.m_szName + " request to web service... Parameters: " + parameter);

            var webservice = new SOAPWebServiceCall(this.m_szName, this.m_Url, this.m_szSOAPMethod, this.error, this.debug);
            webservice.setParams(new Array('_userId', this.m_UserId, '_command', this.m_szName, '_pairParams', parameter));
            webservice.execute(this.onResponse);
            return;
        },

        name: function () {
            return this.m_szName;
        },


        isInProgress: function () {
            return this.m_bInprogress;
        },

     
        onResponse: function (bRequestSuccess, webservice, error, httpstatus) {

           
            STOPMediaRequest.m_bInprogress = false;
            //
            //  Contrairement au autre objet , le media demeure inprogress tant
            //  et aussi longtemps que nous n'avons pas recu d'evenement du serveur
            //  que l'activite a ete termine ou
            //
            //  que la commande STOP n'a pas ete emise par l'agent.
            //
            //
            if (bRequestSuccess == false) {
                webservice = null;
                setTimeout(function () { STOPMediaRequest.executeOnNetworkError(error, httpstatus); }, 50);
                return;
            }

            STOPMediaRequest.m_Parser = new ResponseParser(STOPMediaRequest.m_szName, arguments[2], STOPMediaRequest.error);
            STOPMediaRequest.m_Parser.parse();

            switch (STOPMediaRequest.m_Parser.getStatus()) {
                case "OK":
                    STOPMediaRequest.debug("STOPMediaRequest.onResponse> The media has been stopped...");
                    break;

                case "ERR":
                default:
                    break;
            }

            //
            //  Peu importe le resultat nous mettons l'etat de l'objet media a stop pour eviter les incoherences. Si l'etat du
            //  media ne change pas pour stop, les activite audios sont impossible par la suite pour le restant de l'entrevue
            //
            //
            MEDIARequest.stop();


            //
            //  Creation de l'objet parser... un nouveau a chaque requete.
            //
            try {
                if (STOPMediaRequest.m_Callback.onSuccess != null)
                    STOPMediaRequest.m_Callback.onSuccess(STOPMediaRequest.m_Parser, MEDIARequest.name());
            }
            catch (e) {
                var message = STOPMediaRequest.m_szName + " command caught an exception -- error: " + e.message;
                setTimeout(function () { STOPMediaRequest.error(message); }, 1);
            }

            return;
        },


        executeOnNetworkError: function (error, httpstatus) {

            //
            //  TODO Si necessaire mettre en place un mecanique de reassaie si nous avons des erreurs de transmission
            //  reseau ( command DIAL ) . Voir ICRequest comme exemple
            //
           
            if (STOPMediaRequest.m_iNbError > 3 || httpstatus == 911)
            {
                STOPMediaRequest.m_szErrorType = CommandErrorType.network;
                if (httpstatus == 911)
                    STOPMediaRequest.m_szErrorType = CommandErrorType.javascriptexecption;

                STOPMediaRequest.onError(error);
                STOPMediaRequest.reset();
                return;
            }

            CallStats.addNetworkError();
            STOPMediaRequest.m_iNbError++;
            var webservice = new SOAPWebServiceCall(this.m_szName, this.m_Url, "ExecProntoCommand", this.error, this.debug);
            webservice.setParams(new Array('_userId', ICRequest.m_UserId, '_command', STOPMediaRequest.m_szName, '_pairParams', STOPMediaRequest.m_Parameter));
            webservice.execute(this.onResponse);
        },

        onError: function (error) {

            if (typeof error == "string")
                MEDIARequest.m_szErrorMsg = error;

            ConsoleDebug._error(error);

            if (STOPMediaRequest.m_Callback.onNetworkError != null) {
                STOPMediaRequest.m_Callback.onNetworkError(STOPMediaRequest.m_szName, error);
                return;
            }
        },

        debug: function (message) {

            if (typeof STOPMediaRequest.m_Callback.onLog == "function")
                STOPMediaRequest.m_Callback.onLog(LogLevel.debug, message);

            ConsoleDebug._debug(message);
            return;
        },

        error: function (szMessage) {

            STOPMediaRequest.m_szErrorMsg = szMessage;
            if (typeof STOPMediaRequest.m_Callback.onLog != "function")
                return;

            ConsoleDebug._error(szMessage);
            STOPMediaRequest.m_Callback.onLog(LogLevel.error, szMessage);
            return;
        },

        getError: function () {
            return this.m_szErrorMsg;
        },


        getElapseTime: function () {

            if (this.m_StartTime == null)
                return 0;

            var elapseTime = new Date().getTime() - this.m_StartTime.getTime();
            this.m_StartTime = null;

            return elapseTime;
        },

        reset: function () {
            this.m_szErrorMsg = "";
            this.m_iNbError = 0;
        }
    }

